/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.memory.QueryContextVisitor;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.OperationTimer;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class DriverContext {
    private final PipelineContext pipelineContext;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final AtomicBoolean finished = new AtomicBoolean();
    private final DateTime createdTime = DateTime.now();
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final OperationTimer.OperationTiming overallTiming = new OperationTimer.OperationTiming();
    private final AtomicReference<BlockedMonitor> blockedMonitor = new AtomicReference();
    private final AtomicLong blockedWallNanos = new AtomicLong();
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> executionEndTime = new AtomicReference();
    private final MemoryTrackingContext driverMemoryContext;
    private final DriverYieldSignal yieldSignal;
    private final List<OperatorContext> operatorContexts = new CopyOnWriteArrayList<OperatorContext>();
    private final Lifespan lifespan;

    public DriverContext(PipelineContext pipelineContext, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, MemoryTrackingContext driverMemoryContext, Lifespan lifespan) {
        this.pipelineContext = Objects.requireNonNull(pipelineContext, "pipelineContext is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "scheduler is null");
        this.driverMemoryContext = Objects.requireNonNull(driverMemoryContext, "driverMemoryContext is null");
        this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
        this.yieldSignal = new DriverYieldSignal();
    }

    public TaskId getTaskId() {
        return this.pipelineContext.getTaskId();
    }

    public OperatorContext addOperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        for (OperatorContext operatorContext : this.operatorContexts) {
            Preconditions.checkArgument((operatorId != operatorContext.getOperatorId() ? 1 : 0) != 0, (String)"A context already exists for operatorId %s", (int)operatorId);
        }
        OperatorContext operatorContext = new OperatorContext(operatorId, planNodeId, operatorType, this, this.notificationExecutor, this.driverMemoryContext.newMemoryTrackingContext());
        this.operatorContexts.add(operatorContext);
        return operatorContext;
    }

    public List<OperatorContext> getOperatorContexts() {
        return ImmutableList.copyOf(this.operatorContexts);
    }

    public PipelineContext getPipelineContext() {
        return this.pipelineContext;
    }

    public Session getSession() {
        return this.pipelineContext.getSession();
    }

    public void startProcessTimer() {
        if (this.startNanos.compareAndSet(0L, System.nanoTime())) {
            this.pipelineContext.start();
            this.executionStartTime.set(DateTime.now());
        }
    }

    public void recordProcessed(OperationTimer operationTimer) {
        operationTimer.end(this.overallTiming);
    }

    public void recordBlocked(ListenableFuture<?> blocked) {
        Objects.requireNonNull(blocked, "blocked is null");
        BlockedMonitor monitor = new BlockedMonitor();
        BlockedMonitor oldMonitor = this.blockedMonitor.getAndSet(monitor);
        if (oldMonitor != null) {
            oldMonitor.run();
        }
        blocked.addListener((Runnable)monitor, this.notificationExecutor);
    }

    public void finished() {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        this.executionEndTime.set(DateTime.now());
        this.endNanos.set(System.nanoTime());
        this.pipelineContext.driverFinished(this);
    }

    public void failed(Throwable cause) {
        this.pipelineContext.failed(cause);
        this.finished.set(true);
    }

    public boolean isDone() {
        return this.finished.get() || this.pipelineContext.isDone();
    }

    public ListenableFuture<?> reserveSpill(long bytes) {
        return this.pipelineContext.reserveSpill(bytes);
    }

    public void freeSpill(long bytes) {
        if (bytes == 0L) {
            return;
        }
        Preconditions.checkArgument((bytes > 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.pipelineContext.freeSpill(bytes);
    }

    public DriverYieldSignal getYieldSignal() {
        return this.yieldSignal;
    }

    public long getSystemMemoryUsage() {
        return this.driverMemoryContext.getSystemMemory();
    }

    public long getMemoryUsage() {
        return this.driverMemoryContext.getUserMemory();
    }

    public long getRevocableMemoryUsage() {
        return this.driverMemoryContext.getRevocableMemory();
    }

    public void moreMemoryAvailable() {
        this.operatorContexts.forEach(OperatorContext::moreMemoryAvailable);
    }

    public boolean isPerOperatorCpuTimerEnabled() {
        return this.pipelineContext.isPerOperatorCpuTimerEnabled();
    }

    public boolean isCpuTimerEnabled() {
        return this.pipelineContext.isCpuTimerEnabled();
    }

    public CounterStat getInputDataSize() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getFirst(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getInputDataSize();
        }
        return new CounterStat();
    }

    public CounterStat getInputPositions() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getFirst(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getInputPositions();
        }
        return new CounterStat();
    }

    public CounterStat getOutputDataSize() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getLast(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getOutputDataSize();
        }
        return new CounterStat();
    }

    public CounterStat getOutputPositions() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getLast(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getOutputPositions();
        }
        return new CounterStat();
    }

    public long getPphysicalWrittenDataSize() {
        return this.operatorContexts.stream().mapToLong(OperatorContext::getPhysicalWrittenDataSize).sum();
    }

    public boolean isExecutionStarted() {
        return this.executionStartTime.get() != null;
    }

    public boolean isFullyBlocked() {
        return this.blockedMonitor.get() != null;
    }

    public DriverStats getDriverStats() {
        long outputPositions;
        DataSize outputDataSize;
        long processedInputPositions;
        DataSize processedInputDataSize;
        Duration rawInputReadTime;
        long rawInputPositions;
        DataSize rawInputDataSize;
        ImmutableList operators;
        OperatorStats inputOperator;
        long totalScheduledTime = this.overallTiming.getWallNanos();
        long totalCpuTime = this.overallTiming.getCpuNanos();
        long totalBlockedTime = this.blockedWallNanos.get();
        BlockedMonitor blockedMonitor = this.blockedMonitor.get();
        if (blockedMonitor != null) {
            totalBlockedTime += blockedMonitor.getBlockedTime();
        }
        if ((inputOperator = (OperatorStats)Iterables.getFirst((Iterable)(operators = ImmutableList.copyOf((Iterable)Iterables.transform(this.operatorContexts, OperatorContext::getOperatorStats))), null)) != null) {
            rawInputDataSize = inputOperator.getRawInputDataSize();
            rawInputPositions = inputOperator.getInputPositions();
            rawInputReadTime = inputOperator.getAddInputWall();
            processedInputDataSize = inputOperator.getInputDataSize();
            processedInputPositions = inputOperator.getInputPositions();
            OperatorStats outputOperator = (OperatorStats)Objects.requireNonNull(Iterables.getLast((Iterable)operators, null));
            outputDataSize = outputOperator.getOutputDataSize();
            outputPositions = outputOperator.getOutputPositions();
        } else {
            rawInputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
            rawInputPositions = 0L;
            rawInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
            processedInputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
            processedInputPositions = 0L;
            outputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
            outputPositions = 0L;
        }
        long physicalWrittenDataSize = operators.stream().map(OperatorStats::getPhysicalWrittenDataSize).mapToLong(DataSize::toBytes).sum();
        long startNanos = this.startNanos.get();
        if (startNanos < this.createNanos) {
            startNanos = System.nanoTime();
        }
        Duration queuedTime = new Duration((double)(startNanos - this.createNanos), TimeUnit.NANOSECONDS);
        long endNanos = this.endNanos.get();
        Duration elapsedTime = endNanos >= startNanos ? new Duration((double)(endNanos - this.createNanos), TimeUnit.NANOSECONDS) : new Duration(0.0, TimeUnit.NANOSECONDS);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (OperatorStats operator : operators) {
            if (!operator.getBlockedReason().isPresent()) continue;
            builder.add((Object)operator.getBlockedReason().get());
        }
        return new DriverStats(this.lifespan, this.createdTime, this.executionStartTime.get(), this.executionEndTime.get(), queuedTime.convertToMostSuccinctTimeUnit(), elapsedTime.convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.driverMemoryContext.getUserMemory()), DataSize.succinctBytes((long)this.driverMemoryContext.getRevocableMemory()), DataSize.succinctBytes((long)this.driverMemoryContext.getSystemMemory()), Duration.succinctNanos((long)totalScheduledTime), Duration.succinctNanos((long)totalCpuTime), Duration.succinctNanos((long)totalBlockedTime), blockedMonitor != null, (Set<BlockedReason>)builder.build(), rawInputDataSize.convertToMostSuccinctDataSize(), rawInputPositions, rawInputReadTime, processedInputDataSize.convertToMostSuccinctDataSize(), processedInputPositions, outputDataSize.convertToMostSuccinctDataSize(), outputPositions, DataSize.succinctBytes((long)physicalWrittenDataSize), (List<OperatorStats>)ImmutableList.copyOf((Iterable)Iterables.transform(this.operatorContexts, OperatorContext::getOperatorStats)));
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitDriverContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.operatorContexts.stream().map(operatorContext -> operatorContext.accept(visitor, context)).collect(Collectors.toList());
    }

    public Lifespan getLifespan() {
        return this.lifespan;
    }

    public ScheduledExecutorService getYieldExecutor() {
        return this.yieldExecutor;
    }

    private static long nanosBetween(long start, long end) {
        return Math.max(0L, end - start);
    }

    @VisibleForTesting
    public MemoryTrackingContext getDriverMemoryContext() {
        return this.driverMemoryContext;
    }

    private class BlockedMonitor
    implements Runnable {
        private final long start = System.nanoTime();
        private boolean finished;

        private BlockedMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BlockedMonitor blockedMonitor = this;
            synchronized (blockedMonitor) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                DriverContext.this.blockedMonitor.compareAndSet(this, null);
                DriverContext.this.blockedWallNanos.getAndAdd(this.getBlockedTime());
            }
        }

        public long getBlockedTime() {
            return DriverContext.nanosBetween(this.start, System.nanoTime());
        }
    }
}

