/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TableLayoutResult {
    private final TableLayout layout;
    private final TupleDomain<ColumnHandle> unenforcedConstraint;

    public TableLayoutResult(TableLayout layout, TupleDomain<ColumnHandle> unenforcedConstraint) {
        this.layout = layout;
        this.unenforcedConstraint = unenforcedConstraint;
    }

    public TableLayout getLayout() {
        return this.layout;
    }

    public TupleDomain<ColumnHandle> getUnenforcedConstraint() {
        return this.unenforcedConstraint;
    }

    public boolean hasAllOutputs(TableScanNode node) {
        if (!this.layout.getColumns().isPresent()) {
            return true;
        }
        ImmutableSet columns = ImmutableSet.copyOf((Collection)this.layout.getColumns().get());
        List nodeColumnHandles = (List)node.getOutputSymbols().stream().map(node.getAssignments()::get).collect(ImmutableList.toImmutableList());
        return columns.containsAll(nodeColumnHandles);
    }

    public static TupleDomain<ColumnHandle> computeEnforced(TupleDomain<ColumnHandle> predicate, TupleDomain<ColumnHandle> unenforced) {
        if (predicate.isNone()) {
            if (unenforced.isNone()) {
                return TupleDomain.all();
            }
            if (unenforced.isAll()) {
                return TupleDomain.none();
            }
            throw new IllegalArgumentException();
        }
        Preconditions.checkArgument((!unenforced.isNone() ? 1 : 0) != 0);
        Map predicateDomains = (Map)predicate.getDomains().get();
        Map unenforcedDomains = (Map)unenforced.getDomains().get();
        ImmutableMap.Builder enforcedDomainsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : predicateDomains.entrySet()) {
            ColumnHandle predicateColumnHandle = (ColumnHandle)entry.getKey();
            if (unenforcedDomains.containsKey(predicateColumnHandle)) {
                Preconditions.checkArgument((boolean)((Domain)entry.getValue()).equals(unenforcedDomains.get(predicateColumnHandle)), (Object)"Enforced tuple domain cannot be determined. The connector is expected to enforce the respective domain entirely on none, some, or all of the column.");
                continue;
            }
            enforcedDomainsBuilder.put((Object)predicateColumnHandle, entry.getValue());
        }
        ImmutableMap enforcedDomains = enforcedDomainsBuilder.build();
        Preconditions.checkArgument((enforcedDomains.size() + unenforcedDomains.size() == predicateDomains.size() ? 1 : 0) != 0, (Object)"Enforced tuple domain cannot be determined. Connector returned an unenforced TupleDomain that contains columns not in predicate.");
        return TupleDomain.withColumnDomains((Map)enforcedDomains);
    }
}

