/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.PolymorphicScalarFunctionBuilder;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class PolymorphicScalarFunction
extends SqlScalarFunction {
    private final String description;
    private final boolean hidden;
    private final boolean deterministic;
    private final List<PolymorphicScalarFunctionChoice> choices;

    PolymorphicScalarFunction(Signature signature, String description, boolean hidden, boolean deterministic, List<PolymorphicScalarFunctionChoice> choices) {
        super(signature);
        this.description = description;
        this.hidden = hidden;
        this.deterministic = deterministic;
        this.choices = Objects.requireNonNull(choices, "choices is null");
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        ImmutableList.Builder implementationChoices = ImmutableList.builder();
        for (PolymorphicScalarFunctionChoice choice : this.choices) {
            implementationChoices.add((Object)this.getScalarFunctionImplementationChoice(boundVariables, typeManager, functionManager, choice));
        }
        return new ScalarFunctionImplementation((List<ScalarFunctionImplementation.ScalarImplementationChoice>)implementationChoices.build(), this.deterministic);
    }

    private ScalarFunctionImplementation.ScalarImplementationChoice getScalarFunctionImplementationChoice(BoundVariables boundVariables, TypeManager typeManager, FunctionManager functionManager, PolymorphicScalarFunctionChoice choice) {
        List<TypeSignature> resolvedParameterTypeSignatures = SignatureBinder.applyBoundVariables(this.getSignature().getArgumentTypes(), boundVariables);
        List<Type> resolvedParameterTypes = TypeUtils.resolveTypes(resolvedParameterTypeSignatures, typeManager);
        TypeSignature resolvedReturnTypeSignature = SignatureBinder.applyBoundVariables(this.getSignature().getReturnType(), boundVariables);
        Type resolvedReturnType = typeManager.getType(resolvedReturnTypeSignature);
        PolymorphicScalarFunctionBuilder.SpecializeContext context = new PolymorphicScalarFunctionBuilder.SpecializeContext(boundVariables, resolvedParameterTypes, resolvedReturnType, typeManager, functionManager);
        Optional<Object> matchingMethod = Optional.empty();
        Optional<Object> matchingMethodsGroup = Optional.empty();
        for (PolymorphicScalarFunctionBuilder.MethodsGroup candidateMethodsGroup : choice.getMethodsGroups()) {
            for (PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes candidateMethod : candidateMethodsGroup.getMethods()) {
                if (!PolymorphicScalarFunction.matchesParameterAndReturnTypes(candidateMethod, resolvedParameterTypes, resolvedReturnType, choice.getArgumentProperties(), choice.isNullableResult())) continue;
                if (matchingMethod.isPresent()) {
                    throw new IllegalStateException("two matching methods (" + ((PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes)matchingMethod.get()).getMethod().getName() + " and " + candidateMethod.getMethod().getName() + ") for parameter types " + resolvedParameterTypeSignatures);
                }
                matchingMethod = Optional.of(candidateMethod);
                matchingMethodsGroup = Optional.of(candidateMethodsGroup);
            }
        }
        Preconditions.checkState((boolean)matchingMethod.isPresent(), (String)"no matching method for parameter types %s", resolvedParameterTypes);
        List<Object> extraParameters = PolymorphicScalarFunction.computeExtraParameters((PolymorphicScalarFunctionBuilder.MethodsGroup)matchingMethodsGroup.get(), context);
        MethodHandle methodHandle = this.applyExtraParameters(((PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes)matchingMethod.get()).getMethod(), extraParameters, choice.getArgumentProperties());
        return new ScalarFunctionImplementation.ScalarImplementationChoice(choice.isNullableResult(), choice.getArgumentProperties(), choice.getReturnPlaceConvention(), methodHandle, Optional.empty());
    }

    private static boolean matchesParameterAndReturnTypes(PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes methodAndNativeContainerTypes, List<Type> resolvedTypes, Type returnType, List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties, boolean nullableResult) {
        Method method = methodAndNativeContainerTypes.getMethod();
        Preconditions.checkState((method.getParameterCount() >= resolvedTypes.size() ? 1 : 0) != 0, (String)"method %s has not enough arguments: %s (should have at least %s)", (Object)method.getName(), (Object)method.getParameterCount(), (Object)resolvedTypes.size());
        Class<?>[] methodParameterJavaTypes = method.getParameterTypes();
        int methodParameterIndex = 0;
        for (int i = 0; i < resolvedTypes.size(); ++i) {
            Class<?> actualType;
            ScalarFunctionImplementation.NullConvention nullConvention = argumentProperties.get(i).getNullConvention();
            Class<?> expectedType = null;
            switch (nullConvention) {
                case RETURN_NULL_ON_NULL: 
                case USE_NULL_FLAG: {
                    expectedType = methodParameterJavaTypes[methodParameterIndex];
                    actualType = PolymorphicScalarFunction.getNullAwareContainerType(resolvedTypes.get(i).getJavaType(), false);
                    break;
                }
                case USE_BOXED_TYPE: {
                    expectedType = methodParameterJavaTypes[methodParameterIndex];
                    actualType = PolymorphicScalarFunction.getNullAwareContainerType(resolvedTypes.get(i).getJavaType(), true);
                    break;
                }
                case BLOCK_AND_POSITION: {
                    Optional<Class<?>> explicitNativeContainerTypes = methodAndNativeContainerTypes.getExplicitNativeContainerTypes().get(i);
                    if (explicitNativeContainerTypes.isPresent()) {
                        expectedType = explicitNativeContainerTypes.get();
                    }
                    actualType = PolymorphicScalarFunction.getNullAwareContainerType(resolvedTypes.get(i).getJavaType(), false);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown NullConvention");
                }
            }
            if (!actualType.equals(expectedType)) {
                return false;
            }
            methodParameterIndex += nullConvention.getParameterCount();
        }
        return method.getReturnType().equals(PolymorphicScalarFunction.getNullAwareContainerType(returnType.getJavaType(), nullableResult));
    }

    private static List<Object> computeExtraParameters(PolymorphicScalarFunctionBuilder.MethodsGroup methodsGroup, PolymorphicScalarFunctionBuilder.SpecializeContext context) {
        return methodsGroup.getExtraParametersFunction().map(function -> (List)function.apply(context)).orElse(Collections.emptyList());
    }

    private static int getNullFlagsCount(List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties) {
        return (int)argumentProperties.stream().filter(argumentProperty -> argumentProperty.getNullConvention() == ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG).count();
    }

    private static int getBlockPositionCount(List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties) {
        return (int)argumentProperties.stream().filter(argumentProperty -> argumentProperty.getNullConvention() == ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION).count();
    }

    private MethodHandle applyExtraParameters(Method matchingMethod, List<Object> extraParameters, List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties) {
        Signature signature = this.getSignature();
        int expectedArgumentsCount = signature.getArgumentTypes().size() + PolymorphicScalarFunction.getNullFlagsCount(argumentProperties) + PolymorphicScalarFunction.getBlockPositionCount(argumentProperties) + extraParameters.size();
        int matchingMethodArgumentCount = matchingMethod.getParameterCount();
        Preconditions.checkState((matchingMethodArgumentCount == expectedArgumentsCount ? 1 : 0) != 0, (String)"method %s has invalid number of arguments: %s (should have %s)", (Object)matchingMethod.getName(), (Object)matchingMethodArgumentCount, (Object)expectedArgumentsCount);
        MethodHandle matchingMethodHandle = Reflection.methodHandle(matchingMethod);
        matchingMethodHandle = MethodHandles.insertArguments(matchingMethodHandle, matchingMethodArgumentCount - extraParameters.size(), extraParameters.toArray());
        return matchingMethodHandle;
    }

    private static Class<?> getNullAwareContainerType(Class<?> clazz, boolean nullable) {
        if (nullable) {
            return Primitives.wrap(clazz);
        }
        return clazz;
    }

    static final class PolymorphicScalarFunctionChoice {
        private final boolean nullableResult;
        private final List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties;
        private final ScalarFunctionImplementation.ReturnPlaceConvention returnPlaceConvention;
        private final List<PolymorphicScalarFunctionBuilder.MethodsGroup> methodsGroups;

        PolymorphicScalarFunctionChoice(boolean nullableResult, List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties, ScalarFunctionImplementation.ReturnPlaceConvention returnPlaceConvention, List<PolymorphicScalarFunctionBuilder.MethodsGroup> methodsGroups) {
            this.nullableResult = nullableResult;
            this.argumentProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentProperties, "argumentProperties is null"));
            this.returnPlaceConvention = Objects.requireNonNull(returnPlaceConvention, "returnPlaceConvention is null");
            this.methodsGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(methodsGroups, "methodsWithExtraParametersFunctions is null"));
        }

        boolean isNullableResult() {
            return this.nullableResult;
        }

        List<PolymorphicScalarFunctionBuilder.MethodsGroup> getMethodsGroups() {
            return this.methodsGroups;
        }

        List<ScalarFunctionImplementation.ArgumentProperty> getArgumentProperties() {
            return this.argumentProperties;
        }

        ScalarFunctionImplementation.ReturnPlaceConvention getReturnPlaceConvention() {
            return this.returnPlaceConvention;
        }
    }
}

