/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.OperatorSignatureUtils;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class InternalSignatureUtils {
    private InternalSignatureUtils() {
    }

    public static Signature internalOperator(OperatorType operator, Type returnType, List<? extends Type> argumentTypes) {
        return InternalSignatureUtils.internalScalarFunction(OperatorSignatureUtils.mangleOperatorName(operator.name()), returnType.getTypeSignature(), argumentTypes.stream().map(Type::getTypeSignature).collect(Collectors.toList()));
    }

    public static Signature internalOperator(OperatorType operator, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return InternalSignatureUtils.internalOperator(operator, returnType, Collections.unmodifiableList(Arrays.asList(argumentTypes)));
    }

    public static Signature internalOperator(OperatorType operator, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return InternalSignatureUtils.internalScalarFunction(OperatorSignatureUtils.mangleOperatorName(operator.name()), returnType, argumentTypes);
    }

    public static Signature internalOperator(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return InternalSignatureUtils.internalScalarFunction(OperatorSignatureUtils.mangleOperatorName(name), returnType, argumentTypes);
    }

    public static Signature internalOperator(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return InternalSignatureUtils.internalScalarFunction(OperatorSignatureUtils.mangleOperatorName(name), returnType, Collections.unmodifiableList(Arrays.asList(argumentTypes)));
    }

    public static Signature internalScalarFunction(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return InternalSignatureUtils.internalScalarFunction(name, returnType, Collections.unmodifiableList(Arrays.asList(argumentTypes)));
    }

    public static Signature internalScalarFunction(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return new Signature(name, FunctionKind.SCALAR, Collections.emptyList(), Collections.emptyList(), returnType, argumentTypes, false);
    }
}

