/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class FunctionNamespace {
    private final FunctionRegistry registry;

    public FunctionNamespace(FunctionRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
    }

    public void addFunctions(List<? extends SqlFunction> functions) {
        this.registry.addFunctions(functions);
    }

    public List<SqlFunction> listFunctions() {
        return this.registry.list();
    }

    public FunctionHandle resolveFunction(QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.registry.resolveFunction(name, parameterTypes);
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionHandle functionHandle) {
        return this.registry.getWindowFunctionImplementation(functionHandle);
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(FunctionHandle functionHandle) {
        return this.registry.getAggregateFunctionImplementation(functionHandle);
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(Signature signature) {
        return this.registry.getScalarFunctionImplementation(signature);
    }

    public boolean isAggregationFunction(QualifiedName name) {
        return this.registry.isAggregationFunction(name);
    }

    public FunctionHandle resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        return this.registry.resolveOperator(operatorType, argumentTypes);
    }

    public FunctionHandle lookupCast(OperatorType castType, TypeSignature fromType, TypeSignature toType) {
        return this.registry.lookupCast(castType, fromType, toType);
    }

    public boolean isRegistered(Signature signature) {
        return this.registry.isRegistered(signature);
    }
}

