/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionInvokerProvider;
import com.facebook.presto.metadata.FunctionNamespace;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.TypeRegistry;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FunctionManager {
    private final FunctionNamespace globalFunctionNamespace;
    private final FunctionInvokerProvider functionInvokerProvider;

    public FunctionManager(TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, FeaturesConfig featuresConfig) {
        FunctionRegistry functionRegistry = new FunctionRegistry(typeManager, blockEncodingSerde, featuresConfig, this);
        this.globalFunctionNamespace = new FunctionNamespace(functionRegistry);
        this.functionInvokerProvider = new FunctionInvokerProvider(this);
        if (typeManager instanceof TypeRegistry) {
            ((TypeRegistry)typeManager).setFunctionManager(this);
        }
    }

    public FunctionInvokerProvider getFunctionInvokerProvider() {
        return this.functionInvokerProvider;
    }

    public void addFunctions(List<? extends SqlFunction> functions) {
        this.globalFunctionNamespace.addFunctions(functions);
    }

    public List<SqlFunction> listFunctions() {
        return this.globalFunctionNamespace.listFunctions();
    }

    public FunctionHandle resolveFunction(Session session, QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.globalFunctionNamespace.resolveFunction(name, parameterTypes);
    }

    public Signature resolveFunction(QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.globalFunctionNamespace.resolveFunction(name, parameterTypes).getSignature();
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionHandle functionHandle) {
        return this.globalFunctionNamespace.getWindowFunctionImplementation(functionHandle);
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(FunctionHandle functionHandle) {
        return this.globalFunctionNamespace.getAggregateFunctionImplementation(functionHandle);
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle functionHandle) {
        return this.globalFunctionNamespace.getScalarFunctionImplementation(functionHandle.getSignature());
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(Signature signature) {
        return this.globalFunctionNamespace.getScalarFunctionImplementation(signature);
    }

    public boolean isAggregationFunction(QualifiedName name) {
        return this.globalFunctionNamespace.isAggregationFunction(name);
    }

    public FunctionHandle resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) {
        return this.globalFunctionNamespace.resolveOperator(operatorType, argumentTypes);
    }

    public boolean isRegistered(Signature signature) {
        return this.globalFunctionNamespace.isRegistered(signature);
    }

    public FunctionHandle lookupCast(OperatorType castType, TypeSignature fromType, TypeSignature toType) {
        return this.globalFunctionNamespace.lookupCast(castType, fromType, toType);
    }
}

