/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import javax.validation.constraints.NotNull;

public class NodeMemoryConfig {
    public static final long AVAILABLE_HEAP_MEMORY = Runtime.getRuntime().maxMemory();
    public static final String QUERY_MAX_MEMORY_PER_NODE_CONFIG = "query.max-memory-per-node";
    public static final String QUERY_MAX_TOTAL_MEMORY_PER_NODE_CONFIG = "query.max-total-memory-per-node";
    private boolean isReservedPoolEnabled = true;
    private DataSize maxQueryMemoryPerNode = new DataSize((double)AVAILABLE_HEAP_MEMORY * 0.1, DataSize.Unit.BYTE);
    private DataSize maxQueryTotalMemoryPerNode = new DataSize((double)AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE);
    private DataSize heapHeadroom = new DataSize((double)AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE);

    @NotNull
    public DataSize getMaxQueryMemoryPerNode() {
        return this.maxQueryMemoryPerNode;
    }

    @Config(value="query.max-memory-per-node")
    public NodeMemoryConfig setMaxQueryMemoryPerNode(DataSize maxQueryMemoryPerNode) {
        this.maxQueryMemoryPerNode = maxQueryMemoryPerNode;
        return this;
    }

    public boolean isReservedPoolEnabled() {
        return this.isReservedPoolEnabled;
    }

    @Config(value="experimental.reserved-pool-enabled")
    public NodeMemoryConfig setReservedPoolEnabled(boolean reservedPoolEnabled) {
        this.isReservedPoolEnabled = reservedPoolEnabled;
        return this;
    }

    @NotNull
    public DataSize getMaxQueryTotalMemoryPerNode() {
        return this.maxQueryTotalMemoryPerNode;
    }

    @Config(value="query.max-total-memory-per-node")
    public NodeMemoryConfig setMaxQueryTotalMemoryPerNode(DataSize maxQueryTotalMemoryPerNode) {
        this.maxQueryTotalMemoryPerNode = maxQueryTotalMemoryPerNode;
        return this;
    }

    public DataSize getHeapHeadroom() {
        return this.heapHeadroom;
    }

    @NotNull
    @Config(value="memory.heap-headroom-per-node")
    @ConfigDescription(value="The amount of heap memory to set aside as headroom/buffer (e.g., for untracked allocations)")
    public NodeMemoryConfig setHeapHeadroom(DataSize heapHeadroom) {
        this.heapHeadroom = heapHeadroom;
        return this;
    }
}

