/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.NodeSelector;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.SourcePartitionedScheduler;
import com.facebook.presto.execution.scheduler.SourceScheduler;
import com.facebook.presto.execution.scheduler.SplitPlacementPolicy;
import com.facebook.presto.execution.scheduler.SplitPlacementResult;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.execution.scheduler.group.DynamicLifespanScheduler;
import com.facebook.presto.execution.scheduler.group.FixedLifespanScheduler;
import com.facebook.presto.execution.scheduler.group.LifespanScheduler;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;

public class FixedSourcePartitionedScheduler
implements StageScheduler {
    private static final Logger log = Logger.get(FixedSourcePartitionedScheduler.class);
    private final SqlStageExecution stage;
    private final List<Node> nodes;
    private final List<SourceScheduler> sourceSchedulers;
    private final List<ConnectorPartitionHandle> partitionHandles;
    private boolean scheduledTasks;
    private final Optional<LifespanScheduler> groupedLifespanScheduler;

    public FixedSourcePartitionedScheduler(SqlStageExecution stage, Map<PlanNodeId, SplitSource> splitSources, StageExecutionDescriptor stageExecutionDescriptor, List<PlanNodeId> schedulingOrder, List<Node> nodes, BucketNodeMap bucketNodeMap, int splitBatchSize, OptionalInt concurrentLifespansPerTask, NodeSelector nodeSelector, List<ConnectorPartitionHandle> partitionHandles) {
        Objects.requireNonNull(stage, "stage is null");
        Objects.requireNonNull(splitSources, "splitSources is null");
        Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
        Preconditions.checkArgument((!Objects.requireNonNull(nodes, "nodes is null").isEmpty() ? 1 : 0) != 0, (Object)"nodes is empty");
        Objects.requireNonNull(partitionHandles, "partitionHandles is null");
        this.stage = stage;
        this.nodes = ImmutableList.copyOf(nodes);
        this.partitionHandles = ImmutableList.copyOf(partitionHandles);
        Preconditions.checkArgument((boolean)splitSources.keySet().equals(ImmutableSet.copyOf(schedulingOrder)));
        BucketedSplitPlacementPolicy splitPlacementPolicy = new BucketedSplitPlacementPolicy(nodeSelector, nodes, bucketNodeMap, stage::getAllTasks);
        ArrayList<SourceScheduler> sourceSchedulers = new ArrayList<SourceScheduler>();
        Preconditions.checkArgument((partitionHandles.equals(ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED)) != stageExecutionDescriptor.isStageGroupedExecution() ? 1 : 0) != 0, (Object)"PartitionHandles should be [NOT_PARTITIONED] if and only if all scan nodes use ungrouped execution strategy");
        int nodeCount = nodes.size();
        int concurrentLifespans = concurrentLifespansPerTask.isPresent() && concurrentLifespansPerTask.getAsInt() * nodeCount <= partitionHandles.size() ? concurrentLifespansPerTask.getAsInt() * nodeCount : partitionHandles.size();
        boolean firstPlanNode = true;
        Optional<Object> groupedLifespanScheduler = Optional.empty();
        for (PlanNodeId planNodeId : schedulingOrder) {
            SplitSource splitSource = splitSources.get(planNodeId);
            boolean groupedExecutionForScanNode = stageExecutionDescriptor.isScanGroupedExecution(planNodeId);
            SourceScheduler sourceScheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsSourceScheduler(stage, planNodeId, splitSource, splitPlacementPolicy, Math.max(splitBatchSize / concurrentLifespans, 1), groupedExecutionForScanNode);
            if (stageExecutionDescriptor.isStageGroupedExecution() && !groupedExecutionForScanNode) {
                sourceScheduler = new AsGroupedSourceScheduler(sourceScheduler);
            }
            sourceSchedulers.add(sourceScheduler);
            if (!firstPlanNode) continue;
            firstPlanNode = false;
            if (!stageExecutionDescriptor.isStageGroupedExecution()) {
                sourceScheduler.startLifespan(Lifespan.taskWide(), NotPartitionedPartitionHandle.NOT_PARTITIONED);
                sourceScheduler.noMoreLifespans();
                continue;
            }
            LifespanScheduler lifespanScheduler = bucketNodeMap.isDynamic() ? new DynamicLifespanScheduler(bucketNodeMap, nodes, partitionHandles, concurrentLifespansPerTask) : new FixedLifespanScheduler(bucketNodeMap, partitionHandles, concurrentLifespansPerTask);
            lifespanScheduler.scheduleInitial(sourceScheduler);
            stage.addCompletedDriverGroupsChangedListener(lifespanScheduler::onLifespanFinished);
            groupedLifespanScheduler = Optional.of(lifespanScheduler);
        }
        this.groupedLifespanScheduler = groupedLifespanScheduler;
        this.sourceSchedulers = sourceSchedulers;
    }

    private ConnectorPartitionHandle partitionHandleFor(Lifespan lifespan) {
        if (lifespan.isTaskWide()) {
            return NotPartitionedPartitionHandle.NOT_PARTITIONED;
        }
        return this.partitionHandles.get(lifespan.getId());
    }

    @Override
    public ScheduleResult schedule() {
        Object newTasks = ImmutableList.of();
        if (!this.scheduledTasks) {
            OptionalInt totalPartitions = OptionalInt.of(this.nodes.size());
            newTasks = (List)Streams.mapWithIndex(this.nodes.stream(), (node, id) -> this.stage.scheduleTask((Node)node, Math.toIntExact(id), totalPartitions)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
            this.scheduledTasks = true;
        }
        boolean allBlocked = true;
        ArrayList<Object> blocked = new ArrayList<Object>();
        ScheduleResult.BlockedReason blockedReason = ScheduleResult.BlockedReason.NO_ACTIVE_DRIVER_GROUP;
        if (this.groupedLifespanScheduler.isPresent()) {
            blocked.add(this.groupedLifespanScheduler.get().schedule(this.sourceSchedulers.get(0)));
        }
        int splitsScheduled = 0;
        Iterator<SourceScheduler> schedulerIterator = this.sourceSchedulers.iterator();
        Object driverGroupsToStart = ImmutableList.of();
        boolean shouldInvokeNoMoreDriverGroups = false;
        while (schedulerIterator.hasNext()) {
            SourceScheduler sourceScheduler = schedulerIterator.next();
            for (Lifespan lifespan : driverGroupsToStart) {
                sourceScheduler.startLifespan(lifespan, this.partitionHandleFor(lifespan));
            }
            if (shouldInvokeNoMoreDriverGroups) {
                sourceScheduler.noMoreLifespans();
            }
            ScheduleResult schedule = sourceScheduler.schedule();
            splitsScheduled += schedule.getSplitsScheduled();
            if (schedule.getBlockedReason().isPresent()) {
                blocked.add(schedule.getBlocked());
                blockedReason = blockedReason.combineWith(schedule.getBlockedReason().get());
            } else {
                Verify.verify((boolean)schedule.getBlocked().isDone(), (String)"blockedReason not provided when scheduler is blocked", (Object[])new Object[0]);
                allBlocked = false;
            }
            driverGroupsToStart = sourceScheduler.drainCompletedLifespans();
            if (schedule.isFinished()) {
                this.stage.schedulingComplete(sourceScheduler.getPlanNodeId());
                schedulerIterator.remove();
                sourceScheduler.close();
                shouldInvokeNoMoreDriverGroups = true;
                continue;
            }
            shouldInvokeNoMoreDriverGroups = false;
        }
        if (allBlocked) {
            return new ScheduleResult(this.sourceSchedulers.isEmpty(), (Iterable<? extends RemoteTask>)newTasks, MoreFutures.whenAnyComplete(blocked), blockedReason, splitsScheduled);
        }
        return new ScheduleResult(this.sourceSchedulers.isEmpty(), (Iterable<? extends RemoteTask>)newTasks, splitsScheduled);
    }

    @Override
    public void close() {
        for (SourceScheduler sourceScheduler : this.sourceSchedulers) {
            try {
                sourceScheduler.close();
            }
            catch (Throwable t) {
                log.warn(t, "Error closing split source");
            }
        }
        this.sourceSchedulers.clear();
    }

    private static class AsGroupedSourceScheduler
    implements SourceScheduler {
        private final SourceScheduler sourceScheduler;
        private boolean started;
        private boolean completed;
        private final List<Lifespan> pendingCompleted;

        public AsGroupedSourceScheduler(SourceScheduler sourceScheduler) {
            this.sourceScheduler = Objects.requireNonNull(sourceScheduler, "sourceScheduler is null");
            this.pendingCompleted = new ArrayList<Lifespan>();
        }

        @Override
        public ScheduleResult schedule() {
            return this.sourceScheduler.schedule();
        }

        @Override
        public void close() {
            this.sourceScheduler.close();
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.sourceScheduler.getPlanNodeId();
        }

        @Override
        public void startLifespan(Lifespan lifespan, ConnectorPartitionHandle partitionHandle) {
            this.pendingCompleted.add(lifespan);
            if (this.started) {
                return;
            }
            this.started = true;
            this.sourceScheduler.startLifespan(Lifespan.taskWide(), NotPartitionedPartitionHandle.NOT_PARTITIONED);
            this.sourceScheduler.noMoreLifespans();
        }

        @Override
        public void noMoreLifespans() {
            Preconditions.checkState((boolean)this.started);
        }

        @Override
        public List<Lifespan> drainCompletedLifespans() {
            if (!this.completed) {
                List<Lifespan> lifespans = this.sourceScheduler.drainCompletedLifespans();
                if (lifespans.isEmpty()) {
                    return ImmutableList.of();
                }
                Preconditions.checkState((boolean)ImmutableList.of((Object)Lifespan.taskWide()).equals(lifespans));
                this.completed = true;
            }
            ImmutableList result = ImmutableList.copyOf(this.pendingCompleted);
            this.pendingCompleted.clear();
            return result;
        }
    }

    public static class BucketedSplitPlacementPolicy
    implements SplitPlacementPolicy {
        private final NodeSelector nodeSelector;
        private final List<Node> allNodes;
        private final BucketNodeMap bucketNodeMap;
        private final Supplier<? extends List<RemoteTask>> remoteTasks;

        public BucketedSplitPlacementPolicy(NodeSelector nodeSelector, List<Node> allNodes, BucketNodeMap bucketNodeMap, Supplier<? extends List<RemoteTask>> remoteTasks) {
            this.nodeSelector = Objects.requireNonNull(nodeSelector, "nodeSelector is null");
            this.allNodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(allNodes, "allNodes is null"));
            this.bucketNodeMap = Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
            this.remoteTasks = Objects.requireNonNull(remoteTasks, "remoteTasks is null");
        }

        @Override
        public SplitPlacementResult computeAssignments(Set<Split> splits) {
            return this.nodeSelector.computeAssignments(splits, this.remoteTasks.get(), this.bucketNodeMap);
        }

        @Override
        public void lockDownNodes() {
        }

        @Override
        public List<Node> allNodes() {
            return this.allNodes;
        }

        public Node getNodeForBucket(int bucketId) {
            return this.bucketNodeMap.getAssignedNode(bucketId).get();
        }
    }
}

