/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.Node;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;

public class FixedBucketNodeMap
extends BucketNodeMap {
    private final List<Node> bucketToNode;

    public FixedBucketNodeMap(ToIntFunction<Split> splitToBucket, List<Node> bucketToNode) {
        super(splitToBucket);
        this.bucketToNode = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketToNode, "bucketToNode is null"));
    }

    @Override
    public Optional<Node> getAssignedNode(int bucketedId) {
        return Optional.of(this.bucketToNode.get(bucketedId));
    }

    @Override
    public int getBucketCount() {
        return this.bucketToNode.size();
    }

    @Override
    public void assignBucketToNode(int bucketedId, Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

