/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.Node;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;

public abstract class BucketNodeMap {
    private final ToIntFunction<Split> splitToBucket;

    public BucketNodeMap(ToIntFunction<Split> splitToBucket) {
        this.splitToBucket = Objects.requireNonNull(splitToBucket, "splitToBucket is null");
    }

    public abstract int getBucketCount();

    public abstract Optional<Node> getAssignedNode(int var1);

    public abstract void assignBucketToNode(int var1, Node var2);

    public abstract boolean isDynamic();

    public final Optional<Node> getAssignedNode(Split split) {
        return this.getAssignedNode(this.splitToBucket.applyAsInt(split));
    }
}

