/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.execution.buffer.PageCompression;
import com.facebook.presto.execution.buffer.PagesSerdeUtil;
import com.facebook.presto.execution.buffer.SerializedPage;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.Preconditions;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.lz4.Lz4RawCompressor;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PagesSerde {
    private static final double MINIMUM_COMPRESSION_RATIO = 0.8;
    private final BlockEncodingSerde blockEncodingSerde;
    private final Optional<Compressor> compressor;
    private final Optional<Decompressor> decompressor;

    public PagesSerde(BlockEncodingSerde blockEncodingSerde, Optional<Compressor> compressor, Optional<Decompressor> decompressor) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.compressor = Objects.requireNonNull(compressor, "compressor is null");
        this.decompressor = Objects.requireNonNull(decompressor, "decompressor is null");
        Preconditions.checkArgument((compressor.isPresent() == decompressor.isPresent() ? 1 : 0) != 0, (Object)"compressor and decompressor must both be present or both be absent");
    }

    public SerializedPage serialize(Page page) {
        DynamicSliceOutput serializationBuffer = new DynamicSliceOutput(Math.toIntExact(page.getSizeInBytes() + 4L));
        PagesSerdeUtil.writeRawPage(page, (SliceOutput)serializationBuffer, this.blockEncodingSerde);
        if (!this.compressor.isPresent()) {
            return new SerializedPage(serializationBuffer.slice(), PageCompression.UNCOMPRESSED, page.getPositionCount(), serializationBuffer.size());
        }
        int maxCompressedLength = Lz4RawCompressor.maxCompressedLength((int)serializationBuffer.size());
        byte[] compressionBuffer = new byte[maxCompressedLength];
        int actualCompressedLength = this.compressor.get().compress(serializationBuffer.slice().getBytes(), 0, serializationBuffer.size(), compressionBuffer, 0, maxCompressedLength);
        if (1.0 * (double)actualCompressedLength / (double)serializationBuffer.size() > 0.8) {
            return new SerializedPage(serializationBuffer.slice(), PageCompression.UNCOMPRESSED, page.getPositionCount(), serializationBuffer.size());
        }
        return new SerializedPage(Slices.copyOf((Slice)Slices.wrappedBuffer((byte[])compressionBuffer, (int)0, (int)actualCompressedLength)), PageCompression.COMPRESSED, page.getPositionCount(), serializationBuffer.size());
    }

    public Page deserialize(SerializedPage serializedPage) {
        Preconditions.checkArgument((serializedPage != null ? 1 : 0) != 0, (Object)"serializedPage is null");
        if (!this.decompressor.isPresent() || serializedPage.getCompression() == PageCompression.UNCOMPRESSED) {
            return PagesSerdeUtil.readRawPage(serializedPage.getPositionCount(), (SliceInput)serializedPage.getSlice().getInput(), this.blockEncodingSerde);
        }
        int uncompressedSize = serializedPage.getUncompressedSizeInBytes();
        byte[] decompressed = new byte[uncompressedSize];
        int actualUncompressedSize = this.decompressor.get().decompress(serializedPage.getSlice().getBytes(), 0, serializedPage.getSlice().length(), decompressed, 0, uncompressedSize);
        Preconditions.checkState((uncompressedSize == actualUncompressedSize ? 1 : 0) != 0);
        return PagesSerdeUtil.readRawPage(serializedPage.getPositionCount(), (SliceInput)Slices.wrappedBuffer((byte[])decompressed, (int)0, (int)uncompressedSize).getInput(), this.blockEncodingSerde);
    }
}

