/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.ForQueryExecution;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.MemoryTrackingRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.Output;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.ExecutionPolicy;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.execution.scheduler.SqlQueryScheduler;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.operator.ForScheduler;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DistributedExecutionPlanner;
import com.facebook.presto.sql.planner.InputExtractor;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.OutputExtractor;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.planner.StageExecutionPlan;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.SetThreadName;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.joda.time.DateTime;

@ThreadSafe
public class SqlQueryExecution
implements QueryExecution {
    private static final Logger log = Logger.get(SqlQueryExecution.class);
    private static final OutputBuffers.OutputBufferId OUTPUT_BUFFER_ID = new OutputBuffers.OutputBufferId(0);
    private final QueryStateMachine stateMachine;
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final SplitManager splitManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final NodeScheduler nodeScheduler;
    private final List<PlanOptimizer> planOptimizers;
    private final PlanFragmenter planFragmenter;
    private final RemoteTaskFactory remoteTaskFactory;
    private final LocationFactory locationFactory;
    private final int scheduleSplitBatchSize;
    private final ExecutorService queryExecutor;
    private final ScheduledExecutorService schedulerExecutor;
    private final FailureDetector failureDetector;
    private final AtomicReference<SqlQueryScheduler> queryScheduler = new AtomicReference();
    private final AtomicReference<Plan> queryPlan = new AtomicReference();
    private final NodeTaskMap nodeTaskMap;
    private final ExecutionPolicy executionPolicy;
    private final SplitSchedulerStats schedulerStats;
    private final Analysis analysis;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;

    private SqlQueryExecution(String query, Session session, URI self, ResourceGroupId resourceGroup, QueryPreparer.PreparedQuery preparedQuery, ClusterSizeMonitor clusterSizeMonitor, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, SplitManager splitManager, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, List<PlanOptimizer> planOptimizers, PlanFragmenter planFragmenter, RemoteTaskFactory remoteTaskFactory, LocationFactory locationFactory, int scheduleSplitBatchSize, ExecutorService queryExecutor, ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, NodeTaskMap nodeTaskMap, QueryExplainer queryExplainer, ExecutionPolicy executionPolicy, SplitSchedulerStats schedulerStats, StatsCalculator statsCalculator, CostCalculator costCalculator, WarningCollector warningCollector) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{session.getQueryId()});){
            this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
            this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.schedulerExecutor = Objects.requireNonNull(schedulerExecutor, "schedulerExecutor is null");
            this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
            this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
            this.executionPolicy = Objects.requireNonNull(executionPolicy, "executionPolicy is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            Preconditions.checkArgument((scheduleSplitBatchSize > 0 ? 1 : 0) != 0, (Object)"scheduleSplitBatchSize must be greater than 0");
            this.scheduleSplitBatchSize = scheduleSplitBatchSize;
            Objects.requireNonNull(query, "query is null");
            Objects.requireNonNull(session, "session is null");
            Objects.requireNonNull(self, "self is null");
            this.stateMachine = QueryStateMachine.begin(query, session, self, resourceGroup, false, transactionManager, accessControl, queryExecutor, metadata, warningCollector);
            Objects.requireNonNull(preparedQuery, "preparedQuery is null");
            Analyzer analyzer = new Analyzer(this.stateMachine.getSession(), metadata, sqlParser, accessControl, Optional.of(queryExplainer), preparedQuery.getParameters(), warningCollector);
            try {
                this.analysis = analyzer.analyze(preparedQuery.getStatement());
            }
            catch (RuntimeException e) {
                this.stateMachine.transitionToFailed(e);
                throw e;
            }
            this.stateMachine.setUpdateType(this.analysis.getUpdateType());
            AtomicReference<SqlQueryScheduler> queryScheduler = this.queryScheduler;
            this.stateMachine.addStateChangeListener(state -> {
                if (!state.isDone()) {
                    return;
                }
                SqlQueryScheduler scheduler = (SqlQueryScheduler)queryScheduler.get();
                if (scheduler != null) {
                    scheduler.abort();
                }
            });
            this.remoteTaskFactory = new MemoryTrackingRemoteTaskFactory(Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null"), this.stateMachine);
        }
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public DataSize getUserMemoryReservation() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getUserMemoryReservation();
        }
        if (scheduler == null) {
            return new DataSize(0.0, DataSize.Unit.BYTE);
        }
        return DataSize.succinctBytes((long)scheduler.getUserMemoryReservation());
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalMemoryReservation();
        }
        if (scheduler == null) {
            return new DataSize(0.0, DataSize.Unit.BYTE);
        }
        return DataSize.succinctBytes((long)scheduler.getTotalMemoryReservation());
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalCpuTime();
        }
        if (scheduler == null) {
            return new Duration(0.0, TimeUnit.SECONDS);
        }
        return scheduler.getTotalCpuTime();
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().map(BasicQueryInfo::new).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.ofNullable(this.queryScheduler.get()).map(SqlQueryScheduler::getBasicStageStats)));
    }

    @Override
    public void start() {
        if (this.stateMachine.transitionToWaitingForResources()) {
            this.waitForMinimumWorkers();
        }
    }

    private void waitForMinimumWorkers() {
        ListenableFuture<?> minimumWorkerFuture = this.clusterSizeMonitor.waitForMinimumWorkers();
        MoreFutures.addSuccessCallback(minimumWorkerFuture, () -> this.queryExecutor.submit(this::startExecution));
        MoreFutures.addExceptionCallback(minimumWorkerFuture, throwable -> this.queryExecutor.submit(() -> this.stateMachine.transitionToFailed((Throwable)throwable)));
    }

    private void startExecution() {
        Throwable throwable;
        SetThreadName ignored;
        block24: {
            block25: {
                block26: {
                    block21: {
                        block22: {
                            block23: {
                                ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});
                                throwable = null;
                                if (this.stateMachine.transitionToPlanning()) break block21;
                                if (ignored == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            ignored.close();
                        }
                        return;
                    }
                    PlanRoot plan = this.analyzeQuery();
                    this.metadata.beginQuery(this.getSession(), plan.getConnectors());
                    this.planDistribution(plan);
                    if (this.stateMachine.transitionToStarting()) break block24;
                    if (ignored == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                ignored.close();
            }
            return;
        }
        try {
            try {
                SqlQueryScheduler scheduler = this.queryScheduler.get();
                if (!this.stateMachine.isDone()) {
                    scheduler.start();
                }
            }
            catch (Throwable e) {
                this.fail(e);
                Throwables.throwIfInstanceOf((Throwable)e, Error.class);
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            this.stateMachine.addStateChangeListener(stateChangeListener);
        }
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public Optional<ErrorCode> getErrorCode() {
        return this.stateMachine.getFailureInfo().map(ExecutionFailureInfo::getErrorCode);
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    private PlanRoot analyzeQuery() {
        try {
            return this.doAnalyzeQuery();
        }
        catch (StackOverflowError e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "statement is too large (stack overflow during analysis)", (Throwable)e);
        }
    }

    private PlanRoot doAnalyzeQuery() {
        this.stateMachine.beginAnalysis();
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(false, this.stateMachine.getSession(), this.planOptimizers, idAllocator, this.metadata, this.sqlParser, this.statsCalculator, this.costCalculator, this.stateMachine.getWarningCollector());
        Plan plan = logicalPlanner.plan(this.analysis);
        this.queryPlan.set(plan);
        List<Input> inputs = new InputExtractor(this.metadata, this.stateMachine.getSession()).extractInputs(plan.getRoot());
        this.stateMachine.setInputs(inputs);
        Optional<Output> output = new OutputExtractor().extractOutput(plan.getRoot());
        this.stateMachine.setOutput(output);
        SubPlan fragmentedPlan = this.planFragmenter.createSubPlans(this.stateMachine.getSession(), plan, false, this.stateMachine.getWarningCollector());
        this.stateMachine.endAnalysis();
        boolean explainAnalyze = this.analysis.getStatement() instanceof Explain && ((Explain)this.analysis.getStatement()).isAnalyze();
        return new PlanRoot(fragmentedPlan, !explainAnalyze, SqlQueryExecution.extractConnectors(this.analysis));
    }

    private static Set<ConnectorId> extractConnectors(Analysis analysis) {
        ImmutableSet.Builder connectors = ImmutableSet.builder();
        for (TableHandle tableHandle : analysis.getTables()) {
            connectors.add((Object)tableHandle.getConnectorId());
        }
        if (analysis.getInsert().isPresent()) {
            TableHandle target = analysis.getInsert().get().getTarget();
            connectors.add((Object)target.getConnectorId());
        }
        return connectors.build();
    }

    private void planDistribution(PlanRoot plan) {
        this.stateMachine.beginDistributedPlanning();
        DistributedExecutionPlanner distributedPlanner = new DistributedExecutionPlanner(this.splitManager);
        StageExecutionPlan outputStageExecutionPlan = distributedPlanner.plan(plan.getRoot(), this.stateMachine.getSession());
        this.stateMachine.endDistributedPlanning();
        this.stateMachine.addStateChangeListener(state -> {
            if (state.isDone()) {
                SqlQueryExecution.closeSplitSources(outputStageExecutionPlan);
            }
        });
        if (this.stateMachine.isDone()) {
            return;
        }
        this.stateMachine.setColumns(outputStageExecutionPlan.getFieldNames(), outputStageExecutionPlan.getFragment().getTypes());
        PartitioningHandle partitioningHandle = plan.getRoot().getFragment().getPartitioningScheme().getPartitioning().getHandle();
        OutputBuffers rootOutputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(partitioningHandle).withBuffer(OUTPUT_BUFFER_ID, 0).withNoMoreBufferIds();
        SqlQueryScheduler scheduler = SqlQueryScheduler.createSqlQueryScheduler(this.stateMachine, this.locationFactory, outputStageExecutionPlan, this.nodePartitioningManager, this.nodeScheduler, this.remoteTaskFactory, this.stateMachine.getSession(), plan.isSummarizeTaskInfos(), this.scheduleSplitBatchSize, this.queryExecutor, this.schedulerExecutor, this.failureDetector, rootOutputBuffers, this.nodeTaskMap, this.executionPolicy, this.schedulerStats);
        this.queryScheduler.set(scheduler);
        if (this.stateMachine.isDone()) {
            scheduler.abort();
            this.queryScheduler.set(null);
        }
    }

    private static void closeSplitSources(StageExecutionPlan plan) {
        for (SplitSource source : plan.getSplitSources().values()) {
            try {
                source.close();
            }
            catch (Throwable t) {
                log.warn(t, "Error closing split source");
            }
        }
        for (StageExecutionPlan stage : plan.getSubStages()) {
            SqlQueryExecution.closeSplitSources(stage);
        }
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            if (scheduler != null) {
                scheduler.cancelStage(stageId);
            }
        }
    }

    @Override
    public void fail(Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.stateMachine.transitionToFailed(cause);
    }

    @Override
    public boolean isDone() {
        return this.getState().isDone();
    }

    @Override
    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
        this.stateMachine.addOutputInfoListener(listener);
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.stateMachine.getStateChange(currentState);
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
        this.stateMachine.pruneQueryInfo();
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            QueryInfo queryInfo = this.stateMachine.getFinalQueryInfo().orElseGet(() -> this.buildQueryInfo(scheduler));
            return queryInfo;
        }
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    @Override
    public Plan getQueryPlan() {
        return this.queryPlan.get();
    }

    private QueryInfo buildQueryInfo(SqlQueryScheduler scheduler) {
        QueryInfo queryInfo;
        Optional<StageInfo> stageInfo = Optional.empty();
        if (scheduler != null) {
            stageInfo = Optional.ofNullable(scheduler.getStageInfo());
        }
        if ((queryInfo = this.stateMachine.updateQueryInfo(stageInfo)).isFinalQueryInfo()) {
            this.queryScheduler.set(null);
        }
        return queryInfo;
    }

    public static class SqlQueryExecutionFactory
    implements QueryExecution.QueryExecutionFactory<QueryExecution> {
        private final SplitSchedulerStats schedulerStats;
        private final int scheduleSplitBatchSize;
        private final Metadata metadata;
        private final AccessControl accessControl;
        private final SqlParser sqlParser;
        private final SplitManager splitManager;
        private final NodePartitioningManager nodePartitioningManager;
        private final NodeScheduler nodeScheduler;
        private final List<PlanOptimizer> planOptimizers;
        private final PlanFragmenter planFragmenter;
        private final RemoteTaskFactory remoteTaskFactory;
        private final TransactionManager transactionManager;
        private final QueryExplainer queryExplainer;
        private final LocationFactory locationFactory;
        private final ExecutorService queryExecutor;
        private final ScheduledExecutorService schedulerExecutor;
        private final FailureDetector failureDetector;
        private final NodeTaskMap nodeTaskMap;
        private final Map<String, ExecutionPolicy> executionPolicies;
        private final ClusterSizeMonitor clusterSizeMonitor;
        private final StatsCalculator statsCalculator;
        private final CostCalculator costCalculator;

        @Inject
        SqlQueryExecutionFactory(QueryManagerConfig config, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, LocationFactory locationFactory, SplitManager splitManager, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, PlanOptimizers planOptimizers, PlanFragmenter planFragmenter, RemoteTaskFactory remoteTaskFactory, TransactionManager transactionManager, @ForQueryExecution ExecutorService queryExecutor, @ForScheduler ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, NodeTaskMap nodeTaskMap, QueryExplainer queryExplainer, Map<String, ExecutionPolicy> executionPolicies, SplitSchedulerStats schedulerStats, ClusterSizeMonitor clusterSizeMonitor, StatsCalculator statsCalculator, CostCalculator costCalculator) {
            Objects.requireNonNull(config, "config is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.scheduleSplitBatchSize = config.getScheduleSplitBatchSize();
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            Objects.requireNonNull(planOptimizers, "planOptimizers is null");
            this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
            this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.schedulerExecutor = Objects.requireNonNull(schedulerExecutor, "schedulerExecutor is null");
            this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
            this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.executionPolicies = Objects.requireNonNull(executionPolicies, "schedulerPolicies is null");
            this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
            this.planOptimizers = planOptimizers.get();
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        }

        @Override
        public QueryExecution createQueryExecution(String query, Session session, QueryPreparer.PreparedQuery preparedQuery, ResourceGroupId resourceGroup, WarningCollector warningCollector) {
            String executionPolicyName = SystemSessionProperties.getExecutionPolicy(session);
            ExecutionPolicy executionPolicy = this.executionPolicies.get(executionPolicyName);
            Preconditions.checkArgument((executionPolicy != null ? 1 : 0) != 0, (String)"No execution policy %s", (Object)executionPolicy);
            SqlQueryExecution execution = new SqlQueryExecution(query, session, this.locationFactory.createQueryLocation(session.getQueryId()), resourceGroup, preparedQuery, this.clusterSizeMonitor, this.transactionManager, this.metadata, this.accessControl, this.sqlParser, this.splitManager, this.nodePartitioningManager, this.nodeScheduler, this.planOptimizers, this.planFragmenter, this.remoteTaskFactory, this.locationFactory, this.scheduleSplitBatchSize, this.queryExecutor, this.schedulerExecutor, this.failureDetector, this.nodeTaskMap, this.queryExplainer, executionPolicy, this.schedulerStats, this.statsCalculator, this.costCalculator, warningCollector);
            return execution;
        }
    }

    private static class PlanRoot {
        private final SubPlan root;
        private final boolean summarizeTaskInfos;
        private final Set<ConnectorId> connectors;

        public PlanRoot(SubPlan root, boolean summarizeTaskInfos, Set<ConnectorId> connectors) {
            this.root = Objects.requireNonNull(root, "root is null");
            this.summarizeTaskInfos = summarizeTaskInfos;
            this.connectors = ImmutableSet.copyOf(connectors);
        }

        public SubPlan getRoot() {
            return this.root;
        }

        public boolean isSummarizeTaskInfos() {
            return this.summarizeTaskInfos;
        }

        public Set<ConnectorId> getConnectors() {
            return this.connectors;
        }
    }
}

