/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"query.max-pending-splits-per-node", "query.queue-config-file", "experimental.big-query-initial-hash-partitions", "experimental.max-concurrent-big-queries", "experimental.max-queued-big-queries", "query.remote-task.max-consecutive-error-count"})
public class QueryManagerConfig {
    private int scheduleSplitBatchSize = 1000;
    private int minScheduleSplitBatchSize = 100;
    private int maxConcurrentQueries = 1000;
    private int maxQueuedQueries = 5000;
    private int hashPartitionCount = 100;
    private String partitioningProviderCatalog = "system";
    private Duration minQueryExpireAge = new Duration(15.0, TimeUnit.MINUTES);
    private int maxQueryHistory = 100;
    private int maxQueryLength = 1000000;
    private int maxStageCount = 100;
    private int stageCountWarningThreshold = 50;
    private Duration clientTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private int queryManagerExecutorPoolSize = 5;
    private Duration remoteTaskMaxErrorDuration = new Duration(5.0, TimeUnit.MINUTES);
    private int remoteTaskMaxCallbackThreads = 1000;
    private String queryExecutionPolicy = "all-at-once";
    private Duration queryMaxRunTime = new Duration(100.0, TimeUnit.DAYS);
    private Duration queryMaxExecutionTime = new Duration(100.0, TimeUnit.DAYS);
    private Duration queryMaxCpuTime = new Duration(1.0E9, TimeUnit.DAYS);
    private int initializationRequiredWorkers = 1;
    private Duration initializationTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private int requiredWorkers = 1;
    private Duration requiredWorkersMaxWait = new Duration(5.0, TimeUnit.MINUTES);

    @Min(value=1L)
    public int getScheduleSplitBatchSize() {
        return this.scheduleSplitBatchSize;
    }

    @Config(value="query.schedule-split-batch-size")
    public QueryManagerConfig setScheduleSplitBatchSize(int scheduleSplitBatchSize) {
        this.scheduleSplitBatchSize = scheduleSplitBatchSize;
        return this;
    }

    @Min(value=1L)
    public int getMinScheduleSplitBatchSize() {
        return this.minScheduleSplitBatchSize;
    }

    @Config(value="query.min-schedule-split-batch-size")
    public QueryManagerConfig setMinScheduleSplitBatchSize(int minScheduleSplitBatchSize) {
        this.minScheduleSplitBatchSize = minScheduleSplitBatchSize;
        return this;
    }

    @Deprecated
    @Min(value=1L)
    public int getMaxConcurrentQueries() {
        return this.maxConcurrentQueries;
    }

    @Deprecated
    @Config(value="query.max-concurrent-queries")
    public QueryManagerConfig setMaxConcurrentQueries(int maxConcurrentQueries) {
        this.maxConcurrentQueries = maxConcurrentQueries;
        return this;
    }

    @Deprecated
    @Min(value=1L)
    public int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    @Deprecated
    @Config(value="query.max-queued-queries")
    public QueryManagerConfig setMaxQueuedQueries(int maxQueuedQueries) {
        this.maxQueuedQueries = maxQueuedQueries;
        return this;
    }

    @Min(value=1L)
    public int getHashPartitionCount() {
        return this.hashPartitionCount;
    }

    @LegacyConfig(value={"query.initial-hash-partitions"})
    @Config(value="query.hash-partition-count")
    public QueryManagerConfig setHashPartitionCount(int hashPartitionCount) {
        this.hashPartitionCount = hashPartitionCount;
        return this;
    }

    @NotNull
    public String getPartitioningProviderCatalog() {
        return this.partitioningProviderCatalog;
    }

    @Config(value="query.partitioning-provider-catalog")
    @ConfigDescription(value="Name of the catalog providing custom partitioning")
    public QueryManagerConfig setPartitioningProviderCatalog(String partitioningProviderCatalog) {
        this.partitioningProviderCatalog = partitioningProviderCatalog;
        return this;
    }

    @NotNull
    public Duration getMinQueryExpireAge() {
        return this.minQueryExpireAge;
    }

    @LegacyConfig(value={"query.max-age"})
    @Config(value="query.min-expire-age")
    public QueryManagerConfig setMinQueryExpireAge(Duration minQueryExpireAge) {
        this.minQueryExpireAge = minQueryExpireAge;
        return this;
    }

    @Min(value=0L)
    public int getMaxQueryHistory() {
        return this.maxQueryHistory;
    }

    @Config(value="query.max-history")
    public QueryManagerConfig setMaxQueryHistory(int maxQueryHistory) {
        this.maxQueryHistory = maxQueryHistory;
        return this;
    }

    @Min(value=0L)
    @Max(value=1000000000L)
    public int getMaxQueryLength() {
        return this.maxQueryLength;
    }

    @Config(value="query.max-length")
    public QueryManagerConfig setMaxQueryLength(int maxQueryLength) {
        this.maxQueryLength = maxQueryLength;
        return this;
    }

    @Min(value=1L)
    public int getMaxStageCount() {
        return this.maxStageCount;
    }

    @Config(value="query.max-stage-count")
    public QueryManagerConfig setMaxStageCount(int maxStageCount) {
        this.maxStageCount = maxStageCount;
        return this;
    }

    @Min(value=1L)
    public int getStageCountWarningThreshold() {
        return this.stageCountWarningThreshold;
    }

    @Config(value="query.stage-count-warning-threshold")
    @ConfigDescription(value="Emit a warning when stage count exceeds this threshold")
    public QueryManagerConfig setStageCountWarningThreshold(int stageCountWarningThreshold) {
        this.stageCountWarningThreshold = stageCountWarningThreshold;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="query.client.timeout")
    public QueryManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @Min(value=1L)
    public int getQueryManagerExecutorPoolSize() {
        return this.queryManagerExecutorPoolSize;
    }

    @Config(value="query.manager-executor-pool-size")
    public QueryManagerConfig setQueryManagerExecutorPoolSize(int queryManagerExecutorPoolSize) {
        this.queryManagerExecutorPoolSize = queryManagerExecutorPoolSize;
        return this;
    }

    @Deprecated
    public Duration getRemoteTaskMinErrorDuration() {
        return this.remoteTaskMaxErrorDuration;
    }

    @Deprecated
    @Config(value="query.remote-task.min-error-duration")
    public QueryManagerConfig setRemoteTaskMinErrorDuration(Duration remoteTaskMinErrorDuration) {
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public Duration getRemoteTaskMaxErrorDuration() {
        return this.remoteTaskMaxErrorDuration;
    }

    @Config(value="query.remote-task.max-error-duration")
    public QueryManagerConfig setRemoteTaskMaxErrorDuration(Duration remoteTaskMaxErrorDuration) {
        this.remoteTaskMaxErrorDuration = remoteTaskMaxErrorDuration;
        return this;
    }

    @NotNull
    public Duration getQueryMaxRunTime() {
        return this.queryMaxRunTime;
    }

    @Config(value="query.max-run-time")
    public QueryManagerConfig setQueryMaxRunTime(Duration queryMaxRunTime) {
        this.queryMaxRunTime = queryMaxRunTime;
        return this;
    }

    @NotNull
    public Duration getQueryMaxExecutionTime() {
        return this.queryMaxExecutionTime;
    }

    @Config(value="query.max-execution-time")
    public QueryManagerConfig setQueryMaxExecutionTime(Duration queryMaxExecutionTime) {
        this.queryMaxExecutionTime = queryMaxExecutionTime;
        return this;
    }

    @NotNull
    @MinDuration(value="1ns")
    public Duration getQueryMaxCpuTime() {
        return this.queryMaxCpuTime;
    }

    @Config(value="query.max-cpu-time")
    public QueryManagerConfig setQueryMaxCpuTime(Duration queryMaxCpuTime) {
        this.queryMaxCpuTime = queryMaxCpuTime;
        return this;
    }

    @Min(value=1L)
    public int getRemoteTaskMaxCallbackThreads() {
        return this.remoteTaskMaxCallbackThreads;
    }

    @Config(value="query.remote-task.max-callback-threads")
    public QueryManagerConfig setRemoteTaskMaxCallbackThreads(int remoteTaskMaxCallbackThreads) {
        this.remoteTaskMaxCallbackThreads = remoteTaskMaxCallbackThreads;
        return this;
    }

    @NotNull
    public String getQueryExecutionPolicy() {
        return this.queryExecutionPolicy;
    }

    @Config(value="query.execution-policy")
    public QueryManagerConfig setQueryExecutionPolicy(String queryExecutionPolicy) {
        this.queryExecutionPolicy = queryExecutionPolicy;
        return this;
    }

    @Min(value=1L)
    public int getInitializationRequiredWorkers() {
        return this.initializationRequiredWorkers;
    }

    @Config(value="query-manager.initialization-required-workers")
    @ConfigDescription(value="Minimum number of workers that must be available before the cluster will accept queries")
    public QueryManagerConfig setInitializationRequiredWorkers(int initializationRequiredWorkers) {
        this.initializationRequiredWorkers = initializationRequiredWorkers;
        return this;
    }

    @NotNull
    public Duration getInitializationTimeout() {
        return this.initializationTimeout;
    }

    @Config(value="query-manager.initialization-timeout")
    @ConfigDescription(value="After this time, the cluster will accept queries even if the minimum required workers are not available")
    public QueryManagerConfig setInitializationTimeout(Duration initializationTimeout) {
        this.initializationTimeout = initializationTimeout;
        return this;
    }

    @Min(value=1L)
    public int getRequiredWorkers() {
        return this.requiredWorkers;
    }

    @Config(value="query-manager.required-workers")
    @ConfigDescription(value="Minimum number of active workers that must be available before a query will start")
    public QueryManagerConfig setRequiredWorkers(int requiredWorkers) {
        this.requiredWorkers = requiredWorkers;
        return this;
    }

    @NotNull
    public Duration getRequiredWorkersMaxWait() {
        return this.requiredWorkersMaxWait;
    }

    @Config(value="query-manager.required-workers-max-wait")
    @ConfigDescription(value="Maximum time to wait for minimum number of workers before the query is failed")
    public QueryManagerConfig setRequiredWorkersMaxWait(Duration requiredWorkersMaxWait) {
        this.requiredWorkersMaxWait = requiredWorkersMaxWait;
        return this;
    }
}

