/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.AggregationStatsRule;
import com.facebook.presto.cost.AssignUniqueIdStatsRule;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.EnforceSingleRowStatsRule;
import com.facebook.presto.cost.ExchangeStatsRule;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.FilterStatsRule;
import com.facebook.presto.cost.JoinStatsRule;
import com.facebook.presto.cost.LimitStatsRule;
import com.facebook.presto.cost.OutputStatsRule;
import com.facebook.presto.cost.ProjectStatsRule;
import com.facebook.presto.cost.RowNumberStatsRule;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.SemiJoinStatsRule;
import com.facebook.presto.cost.SimpleFilterProjectSemiJoinStatsRule;
import com.facebook.presto.cost.SortStatsRule;
import com.facebook.presto.cost.SpatialJoinStatsRule;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.TableScanStatsRule;
import com.facebook.presto.cost.UnionStatsRule;
import com.facebook.presto.cost.UnnestStatsRule;
import com.facebook.presto.cost.ValuesStatsRule;
import com.facebook.presto.metadata.Metadata;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.List;
import javax.inject.Singleton;

public class StatsCalculatorModule
implements Module {
    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    public static StatsCalculator createNewStatsCalculator(Metadata metadata) {
        StatsNormalizer normalizer = new StatsNormalizer();
        ScalarStatsCalculator scalarStatsCalculator = new ScalarStatsCalculator(metadata);
        FilterStatsCalculator filterStatsCalculator = new FilterStatsCalculator(metadata, scalarStatsCalculator, normalizer);
        ImmutableList.Builder rules = ImmutableList.builder();
        rules.add((Object)new OutputStatsRule());
        rules.add((Object)new TableScanStatsRule(metadata, normalizer));
        rules.add((Object)new SimpleFilterProjectSemiJoinStatsRule(normalizer, filterStatsCalculator));
        rules.add((Object)new FilterStatsRule(normalizer, filterStatsCalculator));
        rules.add((Object)new ValuesStatsRule(metadata));
        rules.add((Object)new LimitStatsRule(normalizer));
        rules.add((Object)new EnforceSingleRowStatsRule(normalizer));
        rules.add((Object)new ProjectStatsRule(scalarStatsCalculator, normalizer));
        rules.add((Object)new ExchangeStatsRule(normalizer));
        rules.add((Object)new JoinStatsRule(filterStatsCalculator, normalizer));
        rules.add((Object)new SpatialJoinStatsRule(filterStatsCalculator, normalizer));
        rules.add((Object)new AggregationStatsRule(normalizer));
        rules.add((Object)new UnionStatsRule(normalizer));
        rules.add((Object)new AssignUniqueIdStatsRule());
        rules.add((Object)new SemiJoinStatsRule());
        rules.add((Object)new RowNumberStatsRule(normalizer));
        rules.add((Object)new UnnestStatsRule());
        rules.add((Object)new SortStatsRule());
        return new ComposableStatsCalculator((List<ComposableStatsCalculator.Rule<?>>)rules.build());
    }
}

