/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.connector.system.SystemTablesProvider;
import com.facebook.presto.connector.system.SystemTransactionHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.MappedPageSource;
import com.facebook.presto.split.MappedRecordSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SystemPageSourceProvider
implements ConnectorPageSourceProvider {
    private final SystemTablesProvider tables;

    public SystemPageSourceProvider(SystemTablesProvider tables) {
        this.tables = Objects.requireNonNull(tables, "tables is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        SystemTransactionHandle systemTransaction = (SystemTransactionHandle)transactionHandle;
        SystemSplit systemSplit = (SystemSplit)split;
        SchemaTableName tableName = systemSplit.getTableHandle().getSchemaTableName();
        SystemTable systemTable = this.tables.getSystemTable(session, tableName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table %s not found", tableName)));
        List tableColumns = systemTable.getTableMetadata().getColumns();
        HashMap<String, Integer> columnsByName = new HashMap<String, Integer>();
        for (int i = 0; i < tableColumns.size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableColumns.get(i);
            if (columnsByName.put(column.getName(), i) == null) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Duplicate column name: " + column.getName());
        }
        ImmutableList.Builder userToSystemFieldIndex = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            String columnName = ((SystemColumnHandle)column).getColumnName();
            Integer n = (Integer)columnsByName.get(columnName);
            if (n == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Column does not exist: %s.%s", tableName, columnName));
            }
            userToSystemFieldIndex.add((Object)n);
        }
        TupleDomain<ColumnHandle> constraint = systemSplit.getConstraint();
        ImmutableMap.Builder newConstraints = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)constraint.getDomains().get()).entrySet()) {
            String columnName = ((SystemColumnHandle)entry.getKey()).getColumnName();
            newConstraints.put(columnsByName.get(columnName), entry.getValue());
        }
        TupleDomain newContraint = TupleDomain.withColumnDomains((Map)newConstraints.build());
        try {
            return new MappedPageSource(systemTable.pageSource(systemTransaction.getConnectorTransactionHandle(), session, newContraint), (List<Integer>)userToSystemFieldIndex.build());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return new RecordPageSource((RecordSet)new MappedRecordSet(SystemPageSourceProvider.toRecordSet(systemTransaction.getConnectorTransactionHandle(), systemTable, session, (TupleDomain<Integer>)newContraint), (List<Integer>)userToSystemFieldIndex.build()));
        }
    }

    private static RecordSet toRecordSet(final ConnectorTransactionHandle sourceTransaction, final SystemTable table, final ConnectorSession session, final TupleDomain<Integer> constraint) {
        return new RecordSet(){
            private final List<Type> types;
            {
                this.types = (List)table.getTableMetadata().getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
            }

            public List<Type> getColumnTypes() {
                return this.types;
            }

            public RecordCursor cursor() {
                return table.cursor(sourceTransaction, session, constraint);
            }
        };
    }
}

