/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.units.DataSize;

public class ExceededMemoryLimitException
extends PrestoException {
    public static ExceededMemoryLimitException exceededGlobalUserLimit(DataSize maxMemory) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_GLOBAL_MEMORY_LIMIT, String.format("Query exceeded distributed user memory limit of %s", maxMemory));
    }

    public static ExceededMemoryLimitException exceededGlobalTotalLimit(DataSize maxMemory) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_GLOBAL_MEMORY_LIMIT, String.format("Query exceeded distributed total memory limit of %s", maxMemory));
    }

    public static ExceededMemoryLimitException exceededLocalUserMemoryLimit(DataSize maxMemory, String additionalFailureInfo) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT, String.format("Query exceeded per-node user memory limit of %s [%s]", maxMemory, additionalFailureInfo));
    }

    public static ExceededMemoryLimitException exceededLocalTotalMemoryLimit(DataSize maxMemory, String additionalFailureInfo) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT, String.format("Query exceeded per-node total memory limit of %s [%s]", maxMemory, additionalFailureInfo));
    }

    private ExceededMemoryLimitException(StandardErrorCode errorCode, String message) {
        super((ErrorCodeSupplier)errorCode, message);
    }
}

