/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.system.StaticSystemTablesProvider;
import com.facebook.presto.connector.system.SystemTablesMetadata;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.sql.SqlPath;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public final class TestingSession {
    public static final String TESTING_CATALOG = "testing_catalog";
    private static final QueryIdGenerator queryIdGenerator = new QueryIdGenerator();
    public static final TimeZoneKey DEFAULT_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Pacific/Apia");

    private TestingSession() {
    }

    public static Session.SessionBuilder testSessionBuilder() {
        return TestingSession.testSessionBuilder(new SessionPropertyManager());
    }

    public static Session.SessionBuilder testSessionBuilder(SessionPropertyManager sessionPropertyManager) {
        return Session.builder(sessionPropertyManager).setQueryId(queryIdGenerator.createNextQueryId()).setIdentity(new Identity("user", Optional.empty())).setSource("test").setCatalog("catalog").setSchema("schema").setPath(new SqlPath(Optional.of("path"))).setTimeZoneKey(DEFAULT_TIME_ZONE_KEY).setLocale(Locale.ENGLISH).setRemoteUserAddress("address").setUserAgent("agent");
    }

    public static Catalog createBogusTestingCatalog(String catalogName) {
        ConnectorId connectorId = new ConnectorId(catalogName);
        return new Catalog(catalogName, connectorId, TestingSession.createTestSessionConnector(), ConnectorId.createInformationSchemaConnectorId(connectorId), TestingSession.createTestSessionConnector(), ConnectorId.createSystemTablesConnectorId(connectorId), TestingSession.createTestSessionConnector());
    }

    private static Connector createTestSessionConnector() {
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return new ConnectorTransactionHandle(){};
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return new SystemTablesMetadata(new ConnectorId("test_session_connector"), new StaticSystemTablesProvider((Set<SystemTable>)ImmutableSet.of()));
            }

            public ConnectorSplitManager getSplitManager() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

