/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.Session;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class DateTimeTestingUtils {
    private DateTimeTestingUtils() {
    }

    public static SqlTimestamp sqlTimestampOf(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Session session) {
        return DateTimeTestingUtils.sqlTimestampOf(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, DateTimeZoneIndex.getDateTimeZone(session.getTimeZoneKey()), session.getTimeZoneKey(), session.toConnectorSession());
    }

    public static SqlTimestamp sqlTimestampOf(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, DateTimeZone baseZone, TimeZoneKey timestampZone, ConnectorSession session) {
        if (session.isLegacyTimestamp()) {
            return new SqlTimestamp(new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, baseZone).getMillis(), timestampZone);
        }
        return DateTimeTestingUtils.sqlTimestampOf(LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, DateTimeTestingUtils.millisToNanos(millisOfSecond)));
    }

    public static SqlTimestamp sqlTimestampOf(LocalDateTime dateTime) {
        return new SqlTimestamp(TimeUnit.DAYS.toMillis(dateTime.toLocalDate().toEpochDay()) + TimeUnit.NANOSECONDS.toMillis(dateTime.toLocalTime().toNanoOfDay()));
    }

    public static SqlTimestamp sqlTimestampOf(DateTime dateTime, Session session) {
        return DateTimeTestingUtils.sqlTimestampOf(dateTime, session.toConnectorSession());
    }

    private static SqlTimestamp sqlTimestampOf(DateTime dateTime, ConnectorSession session) {
        return DateTimeTestingUtils.sqlTimestampOf(dateTime.getMillis(), session);
    }

    public static SqlTimestamp sqlTimestampOf(long millis, ConnectorSession session) {
        if (session.isLegacyTimestamp()) {
            return new SqlTimestamp(millis, session.getTimeZoneKey());
        }
        return new SqlTimestamp(millis);
    }

    public static SqlTime sqlTimeOf(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Session session) {
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, DateTimeTestingUtils.millisToNanos(millisOfSecond));
        return DateTimeTestingUtils.sqlTimeOf(time, session);
    }

    public static SqlTime sqlTimeOf(LocalTime time, Session session) {
        if (session.toConnectorSession().isLegacyTimestamp()) {
            long millisUtc = LocalDate.ofEpochDay(0L).atTime(time).atZone(ZoneOffset.UTC).withZoneSameLocal(ZoneId.of(session.getTimeZoneKey().getId())).toInstant().toEpochMilli();
            return new SqlTime(millisUtc, session.getTimeZoneKey());
        }
        return new SqlTime(TimeUnit.NANOSECONDS.toMillis(time.toNanoOfDay()));
    }

    private static int millisToNanos(int millisOfSecond) {
        return Math.toIntExact(TimeUnit.MILLISECONDS.toNanos(millisOfSecond));
    }
}

