/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Objects;

public class NoDuplicatePlanNodeIdsChecker
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        HashMap planNodeIds = new HashMap();
        PlanNodeSearcher.searchFrom(planNode).findAll().forEach(node -> planNodeIds.merge(node.getId(), node, this::reportDuplicateId));
    }

    private PlanNode reportDuplicateId(PlanNode first, PlanNode second) {
        Objects.requireNonNull(first, "first is null");
        Objects.requireNonNull(second, "second is null");
        Preconditions.checkArgument((boolean)first.getId().equals(second.getId()));
        throw new IllegalStateException(String.format("Generated plan contains nodes with duplicated id %s: %s and %s", first.getId(), first, second));
    }
}

