/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStats;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NodeRepresentation {
    private final PlanNodeId id;
    private final String name;
    private final String type;
    private final String identifier;
    private final List<Symbol> outputs;
    private final List<PlanNodeId> children;
    private final List<PlanFragmentId> remoteSources;
    private final Optional<PlanNodeStats> stats;
    private final List<PlanNodeStatsEstimate> estimatedStats;
    private final List<PlanNodeCostEstimate> estimatedCost;
    private final StringBuilder details = new StringBuilder();

    public NodeRepresentation(PlanNodeId id, String name, String type, String identifier, List<Symbol> outputs, Optional<PlanNodeStats> stats, List<PlanNodeStatsEstimate> estimatedStats, List<PlanNodeCostEstimate> estimatedCost, List<PlanNodeId> children, List<PlanFragmentId> remoteSources) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.identifier = Objects.requireNonNull(identifier, "identifier is null");
        this.outputs = Objects.requireNonNull(outputs, "outputs is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.estimatedStats = Objects.requireNonNull(estimatedStats, "estimatedStats is null");
        this.estimatedCost = Objects.requireNonNull(estimatedCost, "estimatedCost is null");
        this.children = Objects.requireNonNull(children, "children is null");
        this.remoteSources = Objects.requireNonNull(remoteSources, "remoteSources is null");
        Preconditions.checkArgument((estimatedCost.size() == estimatedStats.size() ? 1 : 0) != 0, (Object)"size of cost and stats list does not match");
    }

    public void appendDetails(String string, Object ... args) {
        if (args.length == 0) {
            this.details.append(string);
        } else {
            this.details.append(String.format(string, args));
        }
    }

    public void appendDetailsLine(String string, Object ... args) {
        this.appendDetails(string, args);
        this.details.append('\n');
    }

    public PlanNodeId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<Symbol> getOutputs() {
        return this.outputs;
    }

    public List<PlanNodeId> getChildren() {
        return this.children;
    }

    public List<PlanFragmentId> getRemoteSources() {
        return this.remoteSources;
    }

    public String getDetails() {
        return this.details.toString();
    }

    public Optional<PlanNodeStats> getStats() {
        return this.stats;
    }

    public List<PlanNodeStatsEstimate> getEstimatedStats() {
        return this.estimatedStats;
    }

    public List<PlanNodeCostEstimate> getEstimatedCost() {
        return this.estimatedCost;
    }
}

