/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Preconditions;
import java.util.List;

public class CheckSubqueryNodesAreRewritten
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        PlanNodeSearcher.searchFrom(plan).where(ApplyNode.class::isInstance).findFirst().ifPresent(node -> {
            ApplyNode applyNode = (ApplyNode)node;
            throw this.error(applyNode.getCorrelation(), applyNode.getOriginSubquery());
        });
        PlanNodeSearcher.searchFrom(plan).where(LateralJoinNode.class::isInstance).findFirst().ifPresent(node -> {
            LateralJoinNode lateralJoinNode = (LateralJoinNode)node;
            throw this.error(lateralJoinNode.getCorrelation(), lateralJoinNode.getOriginSubquery());
        });
        return plan;
    }

    private SemanticException error(List<Symbol> correlation, Node originSubquery) {
        Preconditions.checkState((!correlation.isEmpty() ? 1 : 0) != 0, (Object)"All the non correlated subqueries should be rewritten at this point");
        throw SemanticExceptions.notSupportedException(originSubquery, "Given correlated subquery");
    }
}

