/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ExpressionRewriteRuleSet {
    private final ExpressionRewriter rewriter;

    public ExpressionRewriteRuleSet(ExpressionRewriter rewriter) {
        this.rewriter = Objects.requireNonNull(rewriter, "rewriter is null");
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.aggregationExpressionRewrite(), this.filterExpressionRewrite(), this.joinExpressionRewrite(), this.valuesExpressionRewrite(), this.applyExpressionRewrite(), (Object[])new Rule[0]);
    }

    public Rule<?> projectExpressionRewrite() {
        return new ProjectExpressionRewrite(this.rewriter);
    }

    public Rule<?> aggregationExpressionRewrite() {
        return new AggregationExpressionRewrite(this.rewriter);
    }

    public Rule<?> filterExpressionRewrite() {
        return new FilterExpressionRewrite(this.rewriter);
    }

    public Rule<?> joinExpressionRewrite() {
        return new JoinExpressionRewrite(this.rewriter);
    }

    public Rule<?> valuesExpressionRewrite() {
        return new ValuesExpressionRewrite(this.rewriter);
    }

    public Rule<?> applyExpressionRewrite() {
        return new ApplyExpressionRewrite(this.rewriter);
    }

    private static final class ApplyExpressionRewrite
    implements Rule<ApplyNode> {
        private final ExpressionRewriter rewriter;

        ApplyExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<ApplyNode> getPattern() {
            return Patterns.applyNode();
        }

        @Override
        public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
            Assignments subqueryAssignments = applyNode.getSubqueryAssignments().rewrite(x -> this.rewriter.rewrite((Expression)x, context));
            if (applyNode.getSubqueryAssignments().equals(subqueryAssignments)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new ApplyNode(applyNode.getId(), applyNode.getInput(), applyNode.getSubquery(), subqueryAssignments, applyNode.getCorrelation(), applyNode.getOriginSubquery()));
        }
    }

    private static final class ValuesExpressionRewrite
    implements Rule<ValuesNode> {
        private final ExpressionRewriter rewriter;

        ValuesExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<ValuesNode> getPattern() {
            return Patterns.values();
        }

        @Override
        public Rule.Result apply(ValuesNode valuesNode, Captures captures, Rule.Context context) {
            boolean anyRewritten = false;
            ImmutableList.Builder rows = ImmutableList.builder();
            for (List<Expression> row : valuesNode.getRows()) {
                ImmutableList.Builder newRow = ImmutableList.builder();
                for (Expression expression : row) {
                    Expression rewritten;
                    if (!expression.equals((Object)(rewritten = this.rewriter.rewrite(expression, context)))) {
                        anyRewritten = true;
                    }
                    newRow.add((Object)rewritten);
                }
                rows.add((Object)newRow.build());
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new ValuesNode(valuesNode.getId(), valuesNode.getOutputSymbols(), (List<List<Expression>>)rows.build()));
            }
            return Rule.Result.empty();
        }
    }

    private static final class JoinExpressionRewrite
    implements Rule<JoinNode> {
        private final ExpressionRewriter rewriter;

        JoinExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<JoinNode> getPattern() {
            return Patterns.join();
        }

        @Override
        public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
            Optional<Expression> filter = joinNode.getFilter().map(x -> this.rewriter.rewrite((Expression)x, context));
            if (!joinNode.getFilter().equals(filter)) {
                return Rule.Result.ofPlanNode(new JoinNode(joinNode.getId(), joinNode.getType(), joinNode.getLeft(), joinNode.getRight(), joinNode.getCriteria(), joinNode.getOutputSymbols(), filter, joinNode.getLeftHashSymbol(), joinNode.getRightHashSymbol(), joinNode.getDistributionType()));
            }
            return Rule.Result.empty();
        }
    }

    private static final class FilterExpressionRewrite
    implements Rule<FilterNode> {
        private final ExpressionRewriter rewriter;

        FilterExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return Patterns.filter();
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            Expression rewritten = this.rewriter.rewrite(filterNode.getPredicate(), context);
            if (filterNode.getPredicate().equals((Object)rewritten)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new FilterNode(filterNode.getId(), filterNode.getSource(), rewritten));
        }
    }

    private static final class AggregationExpressionRewrite
    implements Rule<AggregationNode> {
        private final ExpressionRewriter rewriter;

        AggregationExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<AggregationNode> getPattern() {
            return Patterns.aggregation();
        }

        @Override
        public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
            boolean anyRewritten = false;
            ImmutableMap.Builder aggregations = ImmutableMap.builder();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregationNode.getAggregations().entrySet()) {
                AggregationNode.Aggregation aggregation = entry.getValue();
                FunctionCall call = (FunctionCall)this.rewriter.rewrite((Expression)aggregation.getCall(), context);
                aggregations.put((Object)entry.getKey(), (Object)new AggregationNode.Aggregation(call, aggregation.getSignature(), aggregation.getMask()));
                if (aggregation.getCall().equals((Object)call)) continue;
                anyRewritten = true;
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new AggregationNode(aggregationNode.getId(), aggregationNode.getSource(), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), aggregationNode.getGroupingSets(), aggregationNode.getPreGroupedSymbols(), aggregationNode.getStep(), aggregationNode.getHashSymbol(), aggregationNode.getGroupIdSymbol()));
            }
            return Rule.Result.empty();
        }
    }

    private static final class ProjectExpressionRewrite
    implements Rule<ProjectNode> {
        private final ExpressionRewriter rewriter;

        ProjectExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        @Override
        public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
            Assignments assignments = projectNode.getAssignments().rewrite(x -> this.rewriter.rewrite((Expression)x, context));
            if (projectNode.getAssignments().equals(assignments)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new ProjectNode(projectNode.getId(), projectNode.getSource(), assignments));
        }
    }

    public static interface ExpressionRewriter {
        public Expression rewrite(Expression var1, Rule.Context var2);
    }
}

