/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class ExpressionExtractor {
    public static List<Expression> extractExpressions(PlanNode plan) {
        return ExpressionExtractor.extractExpressions(plan, Lookup.noLookup());
    }

    public static List<Expression> extractExpressions(PlanNode plan, Lookup lookup) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(lookup, "lookup is null");
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        plan.accept(new Visitor(true, lookup), expressionsBuilder);
        return expressionsBuilder.build();
    }

    public static List<Expression> extractExpressionsNonRecursive(PlanNode plan) {
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        plan.accept(new Visitor(false, Lookup.noLookup()), expressionsBuilder);
        return expressionsBuilder.build();
    }

    private ExpressionExtractor() {
    }

    private static class Visitor
    extends SimplePlanVisitor<ImmutableList.Builder<Expression>> {
        private final boolean recursive;
        private final Lookup lookup;

        Visitor(boolean recursive, Lookup lookup) {
            this.recursive = recursive;
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        protected Void visitPlan(PlanNode node, ImmutableList.Builder<Expression> context) {
            if (this.recursive) {
                return super.visitPlan(node, context);
            }
            return null;
        }

        @Override
        public Void visitGroupReference(GroupReference node, ImmutableList.Builder<Expression> context) {
            return this.lookup.resolve(node).accept(this, context);
        }

        @Override
        public Void visitAggregation(AggregationNode node, ImmutableList.Builder<Expression> context) {
            node.getAggregations().values().forEach(aggregation -> context.add((Object)aggregation.getCall()));
            return (Void)super.visitAggregation(node, context);
        }

        @Override
        public Void visitFilter(FilterNode node, ImmutableList.Builder<Expression> context) {
            context.add((Object)node.getPredicate());
            return (Void)super.visitFilter(node, context);
        }

        @Override
        public Void visitProject(ProjectNode node, ImmutableList.Builder<Expression> context) {
            context.addAll(node.getAssignments().getExpressions());
            return (Void)super.visitProject(node, context);
        }

        @Override
        public Void visitJoin(JoinNode node, ImmutableList.Builder<Expression> context) {
            node.getFilter().ifPresent(arg_0 -> context.add(arg_0));
            return (Void)super.visitJoin(node, context);
        }

        @Override
        public Void visitValues(ValuesNode node, ImmutableList.Builder<Expression> context) {
            node.getRows().forEach(arg_0 -> context.addAll(arg_0));
            return (Void)super.visitValues(node, context);
        }

        @Override
        public Void visitApply(ApplyNode node, ImmutableList.Builder<Expression> context) {
            context.addAll(node.getSubqueryAssignments().getExpressions());
            return (Void)super.visitApply(node, context);
        }
    }
}

