/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.relational.RowExpression;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FunctionCallCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        FunctionRegistry registry = context.getRegistry();
        ScalarFunctionImplementation function = registry.getScalarFunctionImplementation(signature);
        ArrayList<BytecodeNode> argumentsBytecode = new ArrayList<BytecodeNode>();
        for (int i = 0; i < arguments.size(); ++i) {
            RowExpression argument = arguments.get(i);
            ScalarFunctionImplementation.ArgumentProperty argumentProperty = function.getArgumentProperty(i);
            if (argumentProperty.getArgumentType() == ScalarFunctionImplementation.ArgumentType.VALUE_TYPE) {
                argumentsBytecode.add(context.generate(argument, Optional.empty()));
                continue;
            }
            argumentsBytecode.add(context.generate(argument, Optional.empty(), Optional.of(argumentProperty.getLambdaInterface())));
        }
        return context.generateCall(signature.getName(), function, argumentsBytecode, outputBlockVariable.map(variable -> new BytecodeUtils.OutputBlockVariableAndType((Variable)variable, returnType)));
    }
}

