/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.server.remotetask.RemoteTaskStats;
import com.facebook.presto.server.remotetask.RequestErrorTracker;
import com.facebook.presto.server.remotetask.SimpleHttpResponseCallback;
import com.facebook.presto.server.remotetask.SimpleHttpResponseHandler;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;

public class TaskInfoFetcher
implements SimpleHttpResponseCallback<TaskInfo> {
    private final TaskId taskId;
    private final Consumer<Throwable> onFail;
    private final StateMachine<TaskInfo> taskInfo;
    private final StateMachine<Optional<TaskInfo>> finalTaskInfo;
    private final JsonCodec<TaskInfo> taskInfoCodec;
    private final long updateIntervalMillis;
    private final AtomicLong lastUpdateNanos = new AtomicLong();
    private final ScheduledExecutorService updateScheduledExecutor;
    private final Executor executor;
    private final HttpClient httpClient;
    private final RequestErrorTracker errorTracker;
    private final boolean summarizeTaskInfo;
    @GuardedBy(value="this")
    private final AtomicLong currentRequestStartNanos = new AtomicLong();
    private final RemoteTaskStats stats;
    @GuardedBy(value="this")
    private boolean running;
    @GuardedBy(value="this")
    private ScheduledFuture<?> scheduledFuture;
    @GuardedBy(value="this")
    private ListenableFuture<FullJsonResponseHandler.JsonResponse<TaskInfo>> future;

    public TaskInfoFetcher(Consumer<Throwable> onFail, TaskInfo initialTask, HttpClient httpClient, Duration updateInterval, JsonCodec<TaskInfo> taskInfoCodec, Duration maxErrorDuration, boolean summarizeTaskInfo, Executor executor, ScheduledExecutorService updateScheduledExecutor, ScheduledExecutorService errorScheduledExecutor, RemoteTaskStats stats) {
        Objects.requireNonNull(initialTask, "initialTask is null");
        Objects.requireNonNull(errorScheduledExecutor, "errorScheduledExecutor is null");
        this.taskId = initialTask.getTaskStatus().getTaskId();
        this.onFail = Objects.requireNonNull(onFail, "onFail is null");
        this.taskInfo = new StateMachine<TaskInfo>("task " + this.taskId, executor, initialTask);
        this.finalTaskInfo = new StateMachine("task-" + this.taskId, executor, Optional.empty());
        this.taskInfoCodec = Objects.requireNonNull(taskInfoCodec, "taskInfoCodec is null");
        this.updateIntervalMillis = Objects.requireNonNull(updateInterval, "updateInterval is null").toMillis();
        this.updateScheduledExecutor = Objects.requireNonNull(updateScheduledExecutor, "updateScheduledExecutor is null");
        this.errorTracker = new RequestErrorTracker(this.taskId, initialTask.getTaskStatus().getSelf(), maxErrorDuration, errorScheduledExecutor, "getting info for task");
        this.summarizeTaskInfo = summarizeTaskInfo;
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo.get();
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.scheduleUpdate();
    }

    private synchronized void stop() {
        this.running = false;
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    public void addFinalTaskInfoListener(StateMachine.StateChangeListener<TaskInfo> stateChangeListener) {
        AtomicBoolean done = new AtomicBoolean();
        StateMachine.StateChangeListener<Optional> fireOnceStateChangeListener = finalTaskInfo -> {
            if (finalTaskInfo.isPresent() && done.compareAndSet(false, true)) {
                stateChangeListener.stateChanged((TaskInfo)finalTaskInfo.get());
            }
        };
        this.finalTaskInfo.addStateChangeListener(fireOnceStateChangeListener);
        fireOnceStateChangeListener.stateChanged(this.finalTaskInfo.get());
    }

    private synchronized void scheduleUpdate() {
        this.scheduledFuture = this.updateScheduledExecutor.scheduleWithFixedDelay(() -> {
            TaskInfoFetcher taskInfoFetcher = this;
            synchronized (taskInfoFetcher) {
                if (this.future != null && !this.future.isDone()) {
                    return;
                }
            }
            if (Duration.nanosSince((long)this.lastUpdateNanos.get()).toMillis() >= this.updateIntervalMillis) {
                this.sendNextRequest();
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private synchronized void sendNextRequest() {
        TaskStatus taskStatus = this.getTaskInfo().getTaskStatus();
        if (!this.running) {
            return;
        }
        if (TaskInfoFetcher.isDone(this.getTaskInfo())) {
            this.stop();
            return;
        }
        if (this.future != null && !this.future.isDone()) {
            return;
        }
        ListenableFuture<?> errorRateLimit = this.errorTracker.acquireRequestPermit();
        if (!errorRateLimit.isDone()) {
            errorRateLimit.addListener(this::sendNextRequest, this.executor);
            return;
        }
        HttpUriBuilder httpUriBuilder = HttpUriBuilder.uriBuilderFrom((URI)taskStatus.getSelf());
        URI uri = this.summarizeTaskInfo ? httpUriBuilder.addParameter("summarize", new String[0]).build() : httpUriBuilder.build();
        Request request = Request.Builder.prepareGet().setUri(uri).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).build();
        this.errorTracker.startRequest();
        this.future = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(this.taskInfoCodec));
        this.currentRequestStartNanos.set(System.nanoTime());
        Futures.addCallback(this.future, new SimpleHttpResponseHandler<TaskInfo>(this, request.getUri(), this.stats), (Executor)this.executor);
    }

    synchronized void updateTaskInfo(TaskInfo newValue) {
        boolean updated = this.taskInfo.setIf(newValue, oldValue -> {
            TaskStatus oldTaskStatus = oldValue.getTaskStatus();
            TaskStatus newTaskStatus = newValue.getTaskStatus();
            if (oldTaskStatus.getState().isDone()) {
                return false;
            }
            return newTaskStatus.getVersion() >= oldTaskStatus.getVersion();
        });
        if (updated && newValue.getTaskStatus().getState().isDone()) {
            this.finalTaskInfo.compareAndSet(Optional.empty(), Optional.of(newValue));
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void success(TaskInfo newValue) {
        try (SetThreadName ignored = new SetThreadName("TaskInfoFetcher-%s", new Object[]{this.taskId});){
            long startNanos;
            this.lastUpdateNanos.set(System.nanoTime());
            TaskInfoFetcher taskInfoFetcher = this;
            synchronized (taskInfoFetcher) {
                startNanos = this.currentRequestStartNanos.get();
            }
            this.updateStats(startNanos);
            this.errorTracker.requestSucceeded();
            this.updateTaskInfo(newValue);
        }
    }

    @Override
    public void failed(Throwable cause) {
        try (SetThreadName ignored = new SetThreadName("TaskInfoFetcher-%s", new Object[]{this.taskId});){
            this.lastUpdateNanos.set(System.nanoTime());
            try {
                if (!TaskInfoFetcher.isDone(this.getTaskInfo())) {
                    this.errorTracker.requestFailed(cause);
                }
            }
            catch (Error e) {
                this.onFail.accept(e);
                throw e;
            }
            catch (RuntimeException e) {
                this.onFail.accept(e);
            }
        }
    }

    @Override
    public void fatal(Throwable cause) {
        try (SetThreadName ignored = new SetThreadName("TaskInfoFetcher-%s", new Object[]{this.taskId});){
            this.onFail.accept(cause);
        }
    }

    private void updateStats(long currentRequestStartNanos) {
        this.stats.infoRoundTripMillis(Duration.nanosSince((long)currentRequestStartNanos).toMillis());
    }

    private static boolean isDone(TaskInfo taskInfo) {
        return taskInfo.getTaskStatus().getState().isDone();
    }
}

