/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.Convention;
import com.facebook.presto.spi.function.InvocationConvention;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
public final class ArrayDistinctFromOperator {
    private ArrayDistinctFromOperator() {
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, returnType="boolean", argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle function, @SqlType(value="array(E)") Block left, @IsNull boolean leftNull, @SqlType(value="array(E)") Block right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        if (left.getPositionCount() != right.getPositionCount()) {
            return true;
        }
        for (int i = 0; i < left.getPositionCount(); ++i) {
            try {
                if (!function.invokeExact(left, i, right, i)) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return false;
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, returnType="boolean", argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle elementIsDistinctFrom, @TypeParameter(value="array(E)") Type type, @BlockPosition @SqlType(value="array(E)", nativeContainerType=Block.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="array(E)", nativeContainerType=Block.class) Block right, @BlockIndex int rightPosition) {
        return ArrayDistinctFromOperator.isDistinctFrom(elementIsDistinctFrom, (Block)type.getObject(left, leftPosition), left.isNull(leftPosition), (Block)type.getObject(right, rightPosition), right.isNull(rightPosition));
    }
}

