/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.annotations;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.operator.annotations.ImplementationDependency;
import com.facebook.presto.spi.function.InvocationConvention;
import com.facebook.presto.spi.type.TypeManager;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import java.util.Optional;

public abstract class ScalarImplementationDependency
implements ImplementationDependency {
    private final Signature signature;
    private final Optional<InvocationConvention> invocationConvention;

    protected ScalarImplementationDependency(Signature signature, Optional<InvocationConvention> invocationConvention) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.invocationConvention = invocationConvention;
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public MethodHandle resolve(BoundVariables boundVariables, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Signature signature = SignatureBinder.applyBoundVariables(this.signature, boundVariables, this.signature.getArgumentTypes().size());
        if (this.invocationConvention.isPresent()) {
            return functionRegistry.getFunctionInvokerProvider().createFunctionInvoker(signature, this.invocationConvention).methodHandle();
        }
        return functionRegistry.getScalarFunctionImplementation(signature).getMethodHandle();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScalarImplementationDependency that = (ScalarImplementationDependency)o;
        return Objects.equals(this.signature, that.signature) && Objects.equals(this.invocationConvention, that.invocationConvention);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.invocationConvention);
    }
}

