/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.minmaxby;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.minmaxby.TwoNullableValueStateMapping;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public abstract class AbstractMinMaxBy
extends SqlAggregationFunction {
    private final boolean min;

    protected AbstractMinMaxBy(boolean min) {
        super((min ? "min" : "max") + "_by", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"V"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"V"), (Object)TypeSignature.parseTypeSignature((String)"K")));
        this.min = min;
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        return this.generateAggregation(valueType, keyType, functionRegistry);
    }

    private InternalAggregationFunction generateAggregation(Type valueType, Type keyType, FunctionRegistry functionRegistry) {
        Object stateSerializer;
        AccumulatorStateFactory<? extends AccumulatorState> stateFactory;
        Class<? extends AccumulatorState> stateClazz = TwoNullableValueStateMapping.getStateClass(keyType.getJavaType(), valueType.getJavaType());
        DynamicClassLoader classLoader = new DynamicClassLoader(this.getClass().getClassLoader());
        if (valueType.getJavaType().isPrimitive()) {
            ImmutableMap stateFieldTypes = ImmutableMap.of((Object)"First", (Object)keyType, (Object)"Second", (Object)valueType);
            stateFactory = StateCompiler.generateStateFactory(stateClazz, (Map<String, Type>)stateFieldTypes, classLoader);
            stateSerializer = StateCompiler.generateStateSerializer(stateClazz, (Map<String, Type>)stateFieldTypes, classLoader);
        } else {
            stateFactory = StateCompiler.generateStateFactory(stateClazz, (Map<String, Type>)ImmutableMap.of((Object)"First", (Object)keyType, (Object)"SecondBlock", (Object)new ArrayType(valueType)), classLoader);
            stateSerializer = TwoNullableValueStateMapping.getStateSerializer(keyType, valueType);
        }
        Type intermediateType = stateSerializer.getSerializedType();
        ImmutableList inputTypes = ImmutableList.of((Object)valueType, (Object)keyType);
        CallSiteBinder binder = new CallSiteBinder();
        OperatorType operator = this.min ? OperatorType.LESS_THAN : OperatorType.GREATER_THAN;
        MethodHandle compareMethod = functionRegistry.getScalarFunctionImplementation(functionRegistry.resolveOperator(operator, (List<? extends Type>)ImmutableList.of((Object)keyType, (Object)keyType))).getMethodHandle();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("processMaxOrMinBy"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        this.generateInputMethod(definition, binder, compareMethod, keyType, valueType, stateClazz);
        this.generateCombineMethod(definition, binder, compareMethod, keyType, valueType, stateClazz);
        this.generateOutputMethod(definition, binder, valueType, stateClazz);
        Class<Object> generatedClass = CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), (ClassLoader)classLoader);
        MethodHandle inputMethod = Reflection.methodHandle(generatedClass, "input", stateClazz, Block.class, Block.class, Integer.TYPE);
        MethodHandle combineMethod = Reflection.methodHandle(generatedClass, "combine", stateClazz, stateClazz);
        MethodHandle outputMethod = Reflection.methodHandle(generatedClass, "output", stateClazz, BlockBuilder.class);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.getSignature().getName(), valueType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), AbstractMinMaxBy.createInputParameterMetadata(valueType, keyType), inputMethod, combineMethod, outputMethod, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateClazz, (AccumulatorStateSerializer<?>)stateSerializer, stateFactory)), valueType);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(this.getSignature().getName(), (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), valueType, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value, Type key) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, key), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    private void generateInputMethod(ClassDefinition definition, CallSiteBinder binder, MethodHandle compareMethod, Type keyType, Type valueType, Class<?> stateClass) {
        BytecodeExpression setValueNode;
        Parameter state = Parameter.arg((String)"state", stateClass);
        Parameter value = Parameter.arg((String)"value", Block.class);
        Parameter key = Parameter.arg((String)"key", Block.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "input", ParameterizedType.type(Void.TYPE), new Parameter[]{state, value, key, position});
        SqlTypeBytecodeExpression keySqlType = SqlTypeBytecodeExpression.constantType(binder, keyType);
        BytecodeBlock ifBlock = new BytecodeBlock().append((BytecodeNode)state.invoke("setFirst", Void.TYPE, new BytecodeExpression[]{keySqlType.getValue((BytecodeExpression)key, (BytecodeExpression)position)})).append((BytecodeNode)state.invoke("setFirstNull", Void.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantBoolean((boolean)false)})).append((BytecodeNode)state.invoke("setSecondNull", Void.TYPE, new BytecodeExpression[]{value.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})}));
        if (valueType.getJavaType().isPrimitive()) {
            SqlTypeBytecodeExpression valueSqlType = SqlTypeBytecodeExpression.constantType(binder, valueType);
            setValueNode = state.invoke("setSecond", Void.TYPE, new BytecodeExpression[]{valueSqlType.getValue((BytecodeExpression)value, (BytecodeExpression)position)});
        } else {
            setValueNode = new BytecodeBlock().append((BytecodeNode)state.invoke("setSecondBlock", Void.TYPE, new BytecodeExpression[]{value})).append((BytecodeNode)state.invoke("setSecondPosition", Void.TYPE, new BytecodeExpression[]{position}));
        }
        ifBlock.append((BytecodeNode)new IfStatement().condition((BytecodeNode)value.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})).ifFalse((BytecodeNode)setValueNode));
        method.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)state.invoke("isFirstNull", Boolean.TYPE, new BytecodeExpression[0]), (BytecodeExpression)BytecodeExpressions.and((BytecodeExpression)BytecodeExpressions.not((BytecodeExpression)key.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})), (BytecodeExpression)BytecodeUtils.loadConstant(binder, compareMethod, MethodHandle.class).invoke("invokeExact", Boolean.TYPE, new BytecodeExpression[]{keySqlType.getValue((BytecodeExpression)key, (BytecodeExpression)position), state.invoke("getFirst", keyType.getJavaType(), new BytecodeExpression[0])})))).ifTrue((BytecodeNode)ifBlock)).ret();
    }

    private void generateCombineMethod(ClassDefinition definition, CallSiteBinder binder, MethodHandle compareMethod, Type keyType, Type valueType, Class<?> stateClass) {
        Parameter state = Parameter.arg((String)"state", stateClass);
        Parameter otherState = Parameter.arg((String)"otherState", stateClass);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "combine", ParameterizedType.type(Void.TYPE), new Parameter[]{state, otherState});
        Class keyJavaType = keyType.getJavaType();
        BytecodeBlock ifBlock = new BytecodeBlock().append((BytecodeNode)state.invoke("setFirst", Void.TYPE, new BytecodeExpression[]{otherState.invoke("getFirst", keyJavaType, new BytecodeExpression[0])})).append((BytecodeNode)state.invoke("setFirstNull", Void.TYPE, new BytecodeExpression[]{otherState.invoke("isFirstNull", Boolean.TYPE, new BytecodeExpression[0])})).append((BytecodeNode)state.invoke("setSecondNull", Void.TYPE, new BytecodeExpression[]{otherState.invoke("isSecondNull", Boolean.TYPE, new BytecodeExpression[0])}));
        if (valueType.getJavaType().isPrimitive()) {
            ifBlock.append((BytecodeNode)state.invoke("setSecond", Void.TYPE, new BytecodeExpression[]{otherState.invoke("getSecond", valueType.getJavaType(), new BytecodeExpression[0])}));
        } else {
            ifBlock.append((BytecodeNode)new BytecodeBlock().append((BytecodeNode)state.invoke("setSecondBlock", Void.TYPE, new BytecodeExpression[]{otherState.invoke("getSecondBlock", Block.class, new BytecodeExpression[0])})).append((BytecodeNode)state.invoke("setSecondPosition", Void.TYPE, new BytecodeExpression[]{otherState.invoke("getSecondPosition", Integer.TYPE, new BytecodeExpression[0])})));
        }
        method.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)state.invoke("isFirstNull", Boolean.TYPE, new BytecodeExpression[0]), (BytecodeExpression)BytecodeExpressions.and((BytecodeExpression)BytecodeExpressions.not((BytecodeExpression)otherState.invoke("isFirstNull", Boolean.TYPE, new BytecodeExpression[0])), (BytecodeExpression)BytecodeUtils.loadConstant(binder, compareMethod, MethodHandle.class).invoke("invokeExact", Boolean.TYPE, new BytecodeExpression[]{otherState.invoke("getFirst", keyJavaType, new BytecodeExpression[0]), state.invoke("getFirst", keyJavaType, new BytecodeExpression[0])})))).ifTrue((BytecodeNode)ifBlock)).ret();
    }

    private void generateOutputMethod(ClassDefinition definition, CallSiteBinder binder, Type valueType, Class<?> stateClass) {
        Parameter state = Parameter.arg((String)"state", stateClass);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "output", ParameterizedType.type(Void.TYPE), new Parameter[]{state, out});
        IfStatement ifStatement = new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)state.invoke("isFirstNull", Boolean.TYPE, new BytecodeExpression[0]), (BytecodeExpression)state.invoke("isSecondNull", Boolean.TYPE, new BytecodeExpression[0]))).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)out.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0])).pop());
        SqlTypeBytecodeExpression valueSqlType = SqlTypeBytecodeExpression.constantType(binder, valueType);
        BytecodeExpression getValueExpression = valueType.getJavaType().isPrimitive() ? state.invoke("getSecond", valueType.getJavaType(), new BytecodeExpression[0]) : valueSqlType.getValue(state.invoke("getSecondBlock", Block.class, new BytecodeExpression[0]), state.invoke("getSecondPosition", Integer.TYPE, new BytecodeExpression[0]));
        ifStatement.ifFalse((BytecodeNode)valueSqlType.writeValue((BytecodeExpression)out, getValueExpression));
        method.getBody().append((BytecodeNode)ifStatement).ret();
    }
}

