/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;

@AggregationFunction(value="$internal$max_data_size_for_stats", hidden=true)
public final class MaxDataSizeForStats {
    public static final String NAME = "$internal$max_data_size_for_stats";

    private MaxDataSizeForStats() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState NullableLongState state, @BlockPosition @SqlType(value="T") Block block, @BlockIndex int index) {
        MaxDataSizeForStats.update(state, block.getEstimatedDataSizeForStats(index));
    }

    @CombineFunction
    public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        MaxDataSizeForStats.update(state, otherState.getLong());
    }

    private static void update(NullableLongState state, long size) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(size);
        } else {
            state.setLong(Math.max(state.getLong(), size));
        }
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)BigintType.BIGINT, state, out);
    }
}

