/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.Node;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class AllNodes {
    private final Set<Node> activeNodes;
    private final Set<Node> inactiveNodes;
    private final Set<Node> shuttingDownNodes;
    private final Set<Node> activeCoordinators;

    public AllNodes(Set<Node> activeNodes, Set<Node> inactiveNodes, Set<Node> shuttingDownNodes, Set<Node> activeCoordinators) {
        this.activeNodes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(activeNodes, "activeNodes is null"));
        this.inactiveNodes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(inactiveNodes, "inactiveNodes is null"));
        this.shuttingDownNodes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(shuttingDownNodes, "shuttingDownNodes is null"));
        this.activeCoordinators = ImmutableSet.copyOf((Collection)Objects.requireNonNull(activeCoordinators, "activeCoordinators is null"));
    }

    public Set<Node> getActiveNodes() {
        return this.activeNodes;
    }

    public Set<Node> getInactiveNodes() {
        return this.inactiveNodes;
    }

    public Set<Node> getShuttingDownNodes() {
        return this.shuttingDownNodes;
    }

    public Set<Node> getActiveCoordinators() {
        return this.activeCoordinators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllNodes allNodes = (AllNodes)o;
        return Objects.equals(this.activeNodes, allNodes.activeNodes) && Objects.equals(this.inactiveNodes, allNodes.inactiveNodes) && Objects.equals(this.shuttingDownNodes, allNodes.shuttingDownNodes) && Objects.equals(this.activeCoordinators, allNodes.activeCoordinators);
    }

    public int hashCode() {
        return Objects.hash(this.activeNodes, this.inactiveNodes, this.shuttingDownNodes, this.activeCoordinators);
    }
}

