/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.ParameterExtractor;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.sql.ParsingUtil;
import com.facebook.presto.sql.analyzer.ConstantExpressionVerifier;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.StatementUtils;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class QueryPreparer {
    private final SqlParser sqlParser;

    @Inject
    public QueryPreparer(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    public PreparedQuery prepareQuery(Session session, String query) throws ParsingException, PrestoException, SemanticException {
        Statement wrappedStatement = this.sqlParser.createStatement(query, ParsingUtil.createParsingOptions(session));
        return this.prepareQuery(session, wrappedStatement);
    }

    public PreparedQuery prepareQuery(Session session, Statement wrappedStatement) throws ParsingException, PrestoException, SemanticException {
        Statement innerStatement;
        Optional<QueryType> innerQueryType;
        Statement statement = QueryPreparer.unwrapExecuteStatement(wrappedStatement, this.sqlParser, session);
        if (statement instanceof Explain && ((Explain)statement).isAnalyze() && (!(innerQueryType = StatementUtils.getQueryType((innerStatement = ((Explain)statement).getStatement()).getClass())).isPresent() || innerQueryType.get() == QueryType.DATA_DEFINITION)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "EXPLAIN ANALYZE doesn't support statement type: " + innerStatement.getClass().getSimpleName());
        }
        Object parameters = ImmutableList.of();
        if (wrappedStatement instanceof Execute) {
            parameters = ((Execute)wrappedStatement).getParameters();
        }
        QueryPreparer.validateParameters(statement, (List<Expression>)parameters);
        return new PreparedQuery(statement, (List<Expression>)parameters);
    }

    private static Statement unwrapExecuteStatement(Statement statement, SqlParser sqlParser, Session session) {
        if (!(statement instanceof Execute)) {
            return statement;
        }
        String sql = session.getPreparedStatementFromExecute((Execute)statement);
        return sqlParser.createStatement(sql, ParsingUtil.createParsingOptions(session));
    }

    private static void validateParameters(Statement node, List<Expression> parameterValues) {
        int parameterCount = ParameterExtractor.getParameterCount(node);
        if (parameterValues.size() != parameterCount) {
            throw new SemanticException(SemanticErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Incorrect number of parameters: expected %s but found %s", parameterCount, parameterValues.size());
        }
        for (Expression expression : parameterValues) {
            ConstantExpressionVerifier.verifyExpressionIsConstant(Collections.emptySet(), expression);
        }
    }

    public static class PreparedQuery {
        private final Statement statement;
        private final List<Expression> parameters;

        public PreparedQuery(Statement statement, List<Expression> parameters) {
            this.statement = Objects.requireNonNull(statement, "statement is null");
            this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
        }

        public Statement getStatement() {
            return this.statement;
        }

        public List<Expression> getParameters() {
            return this.parameters;
        }
    }
}

