/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class ClusterSizeMonitor {
    private final InternalNodeManager nodeManager;
    private final boolean includeCoordinator;
    private final int initializationMinCount;
    private final Duration initializationMaxWait;
    private final int executionMinCount;
    private final Duration executionMaxWait;
    private final ScheduledExecutorService executor;
    private final long createNanos = System.nanoTime();
    private final Consumer<AllNodes> listener = this::updateAllNodes;
    @GuardedBy(value="this")
    private int currentCount;
    @GuardedBy(value="this")
    private final List<SettableFuture<?>> futures = new ArrayList();
    @GuardedBy(value="this")
    private boolean minimumWorkerRequirementMet;

    @Inject
    public ClusterSizeMonitor(InternalNodeManager nodeManager, NodeSchedulerConfig nodeSchedulerConfig, QueryManagerConfig queryManagerConfig) {
        this(nodeManager, Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null").isIncludeCoordinator(), Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null").getInitializationRequiredWorkers(), queryManagerConfig.getInitializationTimeout(), queryManagerConfig.getRequiredWorkers(), queryManagerConfig.getRequiredWorkersMaxWait());
    }

    public ClusterSizeMonitor(InternalNodeManager nodeManager, boolean includeCoordinator, int initializationMinCount, Duration initializationMaxWait, int executionMinCount, Duration executionMaxWait) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.includeCoordinator = includeCoordinator;
        Preconditions.checkArgument((initializationMinCount >= 0 ? 1 : 0) != 0, (Object)"initializationMinCount is negative");
        this.initializationMinCount = initializationMinCount;
        this.initializationMaxWait = Objects.requireNonNull(initializationMaxWait, "initializationMaxWait is null");
        Preconditions.checkArgument((executionMinCount >= 0 ? 1 : 0) != 0, (Object)"executionMinCount is negative");
        this.executionMinCount = executionMinCount;
        this.executionMaxWait = Objects.requireNonNull(executionMaxWait, "executionMaxWait is null");
        this.executor = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"node-monitor-%s"));
    }

    @PostConstruct
    public void start() {
        this.nodeManager.addNodeChangeListener(this.listener);
        this.updateAllNodes(this.nodeManager.getAllNodes());
    }

    @PreDestroy
    public void stop() {
        this.nodeManager.removeNodeChangeListener(this.listener);
    }

    public synchronized void verifyInitialMinimumWorkersRequirement() {
        if (this.minimumWorkerRequirementMet) {
            return;
        }
        if (this.currentCount < this.initializationMinCount && Duration.nanosSince((long)this.createNanos).compareTo(this.initializationMaxWait) < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, String.format("Cluster is still initializing, there are insufficient active worker nodes (%s) to run query", this.currentCount));
        }
        this.minimumWorkerRequirementMet = true;
    }

    public synchronized ListenableFuture<?> waitForMinimumWorkers() {
        if (this.currentCount >= this.executionMinCount) {
            return Futures.immediateFuture(null);
        }
        SettableFuture future = SettableFuture.create();
        this.futures.add(future);
        ScheduledFuture<?> timeoutTask = this.executor.schedule(() -> {
            ClusterSizeMonitor clusterSizeMonitor = this;
            synchronized (clusterSizeMonitor) {
                future.setException((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, String.format("Insufficient active worker nodes. Waited %s for at least %s workers, but only %s workers are active", this.executionMaxWait, this.executionMinCount, this.currentCount)));
            }
        }, this.executionMaxWait.toMillis(), TimeUnit.MILLISECONDS);
        future.addListener(() -> {
            timeoutTask.cancel(true);
            this.removeFuture(future);
        }, (Executor)this.executor);
        return future;
    }

    private synchronized void removeFuture(SettableFuture<?> future) {
        this.futures.remove(future);
    }

    private synchronized void updateAllNodes(AllNodes allNodes) {
        this.currentCount = this.includeCoordinator ? allNodes.getActiveNodes().size() : Sets.difference(allNodes.getActiveNodes(), allNodes.getActiveCoordinators()).size();
        if (this.currentCount >= this.executionMinCount) {
            ImmutableList listeners = ImmutableList.copyOf(this.futures);
            this.futures.clear();
            this.executor.submit(() -> listeners.forEach(listener -> listener.set(null)));
        }
    }
}

