/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Traverser;
import java.util.Map;
import java.util.Objects;

public class StatsAndCosts {
    private static final StatsAndCosts EMPTY = new StatsAndCosts((Map<PlanNodeId, PlanNodeStatsEstimate>)ImmutableMap.of(), (Map<PlanNodeId, PlanNodeCostEstimate>)ImmutableMap.of());
    private final Map<PlanNodeId, PlanNodeStatsEstimate> stats;
    private final Map<PlanNodeId, PlanNodeCostEstimate> costs;

    public static StatsAndCosts empty() {
        return EMPTY;
    }

    @JsonCreator
    public StatsAndCosts(@JsonProperty(value="stats") Map<PlanNodeId, PlanNodeStatsEstimate> stats, @JsonProperty(value="costs") Map<PlanNodeId, PlanNodeCostEstimate> costs) {
        this.stats = ImmutableMap.copyOf(Objects.requireNonNull(stats, "stats is null"));
        this.costs = ImmutableMap.copyOf(Objects.requireNonNull(costs, "costs is null"));
    }

    @JsonProperty
    public Map<PlanNodeId, PlanNodeStatsEstimate> getStats() {
        return this.stats;
    }

    @JsonProperty
    public Map<PlanNodeId, PlanNodeCostEstimate> getCosts() {
        return this.costs;
    }

    public StatsAndCosts getForSubplan(PlanNode root) {
        Iterable planIterator = Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root);
        ImmutableMap.Builder filteredStats = ImmutableMap.builder();
        ImmutableMap.Builder filteredCosts = ImmutableMap.builder();
        for (PlanNode node : planIterator) {
            if (this.stats.containsKey(node.getId())) {
                filteredStats.put((Object)node.getId(), (Object)this.stats.get(node.getId()));
            }
            if (!this.costs.containsKey(node.getId())) continue;
            filteredCosts.put((Object)node.getId(), (Object)this.costs.get(node.getId()));
        }
        return new StatsAndCosts((Map<PlanNodeId, PlanNodeStatsEstimate>)filteredStats.build(), (Map<PlanNodeId, PlanNodeCostEstimate>)filteredCosts.build());
    }

    public static StatsAndCosts create(PlanNode root, StatsProvider statsProvider, CostProvider costProvider) {
        Iterable planIterator = Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root);
        ImmutableMap.Builder stats = ImmutableMap.builder();
        ImmutableMap.Builder costs = ImmutableMap.builder();
        for (PlanNode node : planIterator) {
            stats.put((Object)node.getId(), (Object)statsProvider.getStats(node));
            costs.put((Object)node.getId(), (Object)costProvider.getCumulativeCost(node));
        }
        return new StatsAndCosts((Map<PlanNodeId, PlanNodeStatsEstimate>)stats.build(), (Map<PlanNodeId, PlanNodeCostEstimate>)costs.build());
    }
}

