/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class TransactionsSystemTable
implements SystemTable {
    public static final SchemaTableName TRANSACTIONS_TABLE_NAME = new SchemaTableName("runtime", "transactions");
    private final ConnectorTableMetadata transactionsTable;
    private final TransactionManager transactionManager;

    @Inject
    public TransactionsSystemTable(TypeManager typeManager, TransactionManager transactionManager) {
        this.transactionsTable = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TRANSACTIONS_TABLE_NAME).column("transaction_id", (Type)VarcharType.createUnboundedVarcharType()).column("isolation_level", (Type)VarcharType.createUnboundedVarcharType()).column("read_only", (Type)BooleanType.BOOLEAN).column("auto_commit_context", (Type)BooleanType.BOOLEAN).column("create_time", (Type)TimestampType.TIMESTAMP).column("idle_time_secs", (Type)BigintType.BIGINT).column("written_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("catalogs", typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)VarcharType.createUnboundedVarcharType().getTypeSignature())))).build();
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.transactionsTable;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)this.transactionsTable);
        for (TransactionInfo info : this.transactionManager.getAllTransactionInfos()) {
            table.addRow(new Object[]{info.getTransactionId().toString(), info.getIsolationLevel().toString(), info.isReadOnly(), info.isAutoCommitContext(), info.getCreateTime().getMillis(), (long)info.getIdleTime().getValue(TimeUnit.SECONDS), info.getWrittenConnectorId().map(ConnectorId::getCatalogName).orElse(null), TransactionsSystemTable.createStringsBlock(info.getConnectorIds())});
        }
        return table.build().cursor();
    }

    private static Block createStringsBlock(List<ConnectorId> values) {
        VarcharType varchar = VarcharType.createUnboundedVarcharType();
        BlockBuilder builder = varchar.createBlockBuilder(null, values.size());
        for (ConnectorId value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            varchar.writeString(builder, value.getCatalogName());
        }
        return builder.build();
    }
}

