/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.re2j.Matcher;
import com.google.re2j.Options;
import com.google.re2j.Pattern;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;

public final class Re2JRegexp {
    private static final Logger log = Logger.get(Re2JRegexp.class);
    private static final java.util.regex.Pattern DOT_STAR_PREFIX_PATTERN = java.util.regex.Pattern.compile("(?s)^(\\.\\*\\??)?(.*)");
    private static final int CORE_PATTERN_INDEX = 2;
    public final int dfaStatesLimit;
    public final int dfaRetries;
    public final Pattern re2jPattern;
    public final Pattern re2jPatternWithoutDotStartPrefix;

    public Re2JRegexp(int dfaStatesLimit, int dfaRetries, Slice pattern) {
        this.dfaStatesLimit = dfaStatesLimit;
        this.dfaRetries = dfaRetries;
        Options options = Options.builder().setAlgorithm(Options.Algorithm.DFA_FALLBACK_TO_NFA).setMaximumNumberOfDFAStates(dfaStatesLimit).setNumberOfDFARetries(dfaRetries).setEventsListener((Options.EventsListener)new RE2JEventsListener()).build();
        String patternString = pattern.toStringUtf8();
        this.re2jPattern = Pattern.compile((String)patternString, (Options)options);
        java.util.regex.Matcher dotStarPrefixMatcher = DOT_STAR_PREFIX_PATTERN.matcher(patternString);
        Preconditions.checkState((boolean)dotStarPrefixMatcher.matches());
        String patternStringWithoutDotStartPrefix = dotStarPrefixMatcher.group(2);
        this.re2jPatternWithoutDotStartPrefix = !patternStringWithoutDotStartPrefix.equals(patternString) ? Pattern.compile((String)patternStringWithoutDotStartPrefix, (Options)options) : this.re2jPattern;
    }

    public boolean matches(Slice source) {
        return this.re2jPatternWithoutDotStartPrefix.find(source);
    }

    public Slice replace(Slice source, Slice replacement) {
        Matcher matcher = this.re2jPattern.matcher(source);
        try {
            return matcher.replaceAll(replacement);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Illegal replacement sequence: " + replacement.toStringUtf8());
        }
    }

    public Block extractAll(Slice source, long groupIndex) {
        Matcher matcher = this.re2jPattern.matcher(source);
        int group = Math.toIntExact(groupIndex);
        Re2JRegexp.validateGroup(group, matcher.groupCount());
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 32);
        while (matcher.find()) {
            Slice searchedGroup = matcher.group(group);
            if (searchedGroup == null) {
                blockBuilder.appendNull();
                continue;
            }
            VarcharType.VARCHAR.writeSlice(blockBuilder, searchedGroup);
        }
        return blockBuilder.build();
    }

    public Slice extract(Slice source, long groupIndex) {
        Matcher matcher = this.re2jPattern.matcher(source);
        int group = Math.toIntExact(groupIndex);
        Re2JRegexp.validateGroup(group, matcher.groupCount());
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(group);
    }

    public Block split(Slice source) {
        Matcher matcher = this.re2jPattern.matcher(source);
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 32);
        int lastEnd = 0;
        while (matcher.find()) {
            Slice slice = source.slice(lastEnd, matcher.start() - lastEnd);
            lastEnd = matcher.end();
            VarcharType.VARCHAR.writeSlice(blockBuilder, slice);
        }
        VarcharType.VARCHAR.writeSlice(blockBuilder, source.slice(lastEnd, source.length() - lastEnd));
        return blockBuilder.build();
    }

    private static void validateGroup(int group, int groupCount) {
        if (group < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Group cannot be negative");
        }
        if (group > groupCount) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Pattern has %d groups. Cannot access group %d", groupCount, group));
        }
    }

    private class RE2JEventsListener
    implements Options.EventsListener {
        private RE2JEventsListener() {
        }

        public void fallbackToNFA() {
            log.debug("Fallback to NFA, pattern: %s, DFA states limit: %d, DFA retries: %d", new Object[]{Re2JRegexp.this.re2jPattern.pattern(), Re2JRegexp.this.dfaStatesLimit, Re2JRegexp.this.dfaRetries});
        }
    }
}

