/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.sanity.NoDuplicatePlanNodeIdsChecker;
import com.facebook.presto.sql.planner.sanity.NoIdentifierLeftChecker;
import com.facebook.presto.sql.planner.sanity.NoSubqueryExpressionLeftChecker;
import com.facebook.presto.sql.planner.sanity.TypeValidator;
import com.facebook.presto.sql.planner.sanity.ValidateAggregationsWithDefaultValues;
import com.facebook.presto.sql.planner.sanity.ValidateDependenciesChecker;
import com.facebook.presto.sql.planner.sanity.ValidateStreamingAggregations;
import com.facebook.presto.sql.planner.sanity.VerifyNoFilteredAggregations;
import com.facebook.presto.sql.planner.sanity.VerifyOnlyOneOutputNode;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;

public final class PlanSanityChecker {
    public static final PlanSanityChecker DISTRIBUTED_PLAN_SANITY_CHECKER = new PlanSanityChecker(false);
    private final Multimap<Stage, Checker> checkers;

    public PlanSanityChecker(boolean forceSingleNode) {
        this.checkers = ImmutableListMultimap.builder().putAll((Object)Stage.INTERMEDIATE, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new NoIdentifierLeftChecker(), new VerifyOnlyOneOutputNode()}).putAll((Object)Stage.FINAL, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new NoIdentifierLeftChecker(), new VerifyOnlyOneOutputNode(), new VerifyNoFilteredAggregations(), new ValidateAggregationsWithDefaultValues(forceSingleNode), new ValidateStreamingAggregations()}).build();
    }

    public void validateFinalPlan(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.FINAL).forEach(checker -> checker.validate(planNode, session, metadata, sqlParser, types, warningCollector));
    }

    public void validateIntermediatePlan(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.INTERMEDIATE).forEach(checker -> checker.validate(planNode, session, metadata, sqlParser, types, warningCollector));
    }

    private static enum Stage {
        INTERMEDIATE,
        FINAL;

    }

    public static interface Checker {
        public void validate(PlanNode var1, Session var2, Metadata var3, SqlParser var4, TypeProvider var5, WarningCollector var6);
    }
}

