/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.operator.HashCollisionsInfo;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.operator.WindowInfo;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.planPrinter.OperatorHashCollisionsStats;
import com.facebook.presto.sql.planner.planPrinter.OperatorInputStats;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStats;
import com.facebook.presto.sql.planner.planPrinter.WindowOperatorStats;
import com.facebook.presto.util.MoreMaps;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class PlanNodeStatsSummarizer {
    private PlanNodeStatsSummarizer() {
    }

    public static Map<PlanNodeId, PlanNodeStats> aggregatePlanNodeStats(List<StageInfo> stageInfos) {
        HashMap<PlanNodeId, PlanNodeStats> aggregatedStats = new HashMap<PlanNodeId, PlanNodeStats>();
        List planNodeStats = stageInfos.stream().flatMap(stageInfo -> stageInfo.getTasks().stream()).map(TaskInfo::getStats).flatMap(taskStats -> PlanNodeStatsSummarizer.getPlanNodeStats(taskStats).stream()).collect(Collectors.toList());
        for (PlanNodeStats stats : planNodeStats) {
            aggregatedStats.merge(stats.getPlanNodeId(), stats, (left, right) -> left.mergeWith((PlanNodeStats)right));
        }
        return aggregatedStats;
    }

    private static List<PlanNodeStats> getPlanNodeStats(TaskStats taskStats) {
        HashSet<PlanNodeId> planNodeIds = new HashSet<PlanNodeId>();
        HashMap<PlanNodeId, Long> planNodeInputPositions = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeInputBytes = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeOutputPositions = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeOutputBytes = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeScheduledMillis = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeCpuMillis = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Map> operatorInputStats = new HashMap<PlanNodeId, Map>();
        HashMap operatorHashCollisionsStats = new HashMap();
        HashMap<PlanNodeId, WindowOperatorStats> windowNodeStats = new HashMap<PlanNodeId, WindowOperatorStats>();
        for (PipelineStats pipelineStats : taskStats.getPipelines()) {
            PlanNodeId planNodeId;
            if (pipelineStats.getOperatorSummaries().isEmpty()) continue;
            HashSet<PlanNodeId> processedNodes = new HashSet<PlanNodeId>();
            PlanNodeId inputPlanNode = pipelineStats.getOperatorSummaries().iterator().next().getPlanNodeId();
            PlanNodeId outputPlanNode = ((OperatorStats)Iterables.getLast(pipelineStats.getOperatorSummaries())).getPlanNodeId();
            for (OperatorStats operatorStats : pipelineStats.getOperatorSummaries()) {
                planNodeId = operatorStats.getPlanNodeId();
                planNodeIds.add(planNodeId);
                long scheduledMillis = operatorStats.getAddInputWall().toMillis() + operatorStats.getGetOutputWall().toMillis() + operatorStats.getFinishWall().toMillis();
                planNodeScheduledMillis.merge(planNodeId, scheduledMillis, Long::sum);
                long cpuMillis = operatorStats.getAddInputCpu().toMillis() + operatorStats.getGetOutputCpu().toMillis() + operatorStats.getFinishCpu().toMillis();
                planNodeCpuMillis.merge(planNodeId, cpuMillis, Long::sum);
                if (operatorStats.getPlanNodeId().equals(inputPlanNode) && !pipelineStats.isInputPipeline() || processedNodes.contains(planNodeId)) continue;
                operatorInputStats.merge(planNodeId, (Map)ImmutableMap.of((Object)operatorStats.getOperatorType(), (Object)new OperatorInputStats(operatorStats.getTotalDrivers(), operatorStats.getInputPositions(), operatorStats.getSumSquaredInputPositions())), (map1, map2) -> MoreMaps.mergeMaps(map1, map2, OperatorInputStats::merge));
                if (operatorStats.getInfo() instanceof HashCollisionsInfo) {
                    HashCollisionsInfo hashCollisionsInfo = (HashCollisionsInfo)operatorStats.getInfo();
                    operatorHashCollisionsStats.merge(planNodeId, ImmutableMap.of((Object)operatorStats.getOperatorType(), (Object)new OperatorHashCollisionsStats(hashCollisionsInfo.getWeightedHashCollisions(), hashCollisionsInfo.getWeightedSumSquaredHashCollisions(), hashCollisionsInfo.getWeightedExpectedHashCollisions())), (map1, map2) -> MoreMaps.mergeMaps(map1, map2, OperatorHashCollisionsStats::merge));
                }
                if (operatorStats.getInfo() instanceof WindowInfo) {
                    WindowInfo windowInfo = (WindowInfo)operatorStats.getInfo();
                    windowNodeStats.merge(planNodeId, WindowOperatorStats.create(windowInfo), (left, right) -> left.mergeWith((WindowOperatorStats)right));
                }
                planNodeInputPositions.merge(planNodeId, operatorStats.getInputPositions(), Long::sum);
                planNodeInputBytes.merge(planNodeId, operatorStats.getInputDataSize().toBytes(), Long::sum);
                processedNodes.add(planNodeId);
            }
            processedNodes.clear();
            for (OperatorStats operatorStats : Lists.reverse(pipelineStats.getOperatorSummaries())) {
                planNodeId = operatorStats.getPlanNodeId();
                if (operatorStats.getPlanNodeId().equals(outputPlanNode) && !pipelineStats.isOutputPipeline() || processedNodes.contains(planNodeId)) continue;
                planNodeOutputPositions.merge(planNodeId, operatorStats.getOutputPositions(), Long::sum);
                planNodeOutputBytes.merge(planNodeId, operatorStats.getOutputDataSize().toBytes(), Long::sum);
                processedNodes.add(planNodeId);
            }
        }
        ArrayList<PlanNodeStats> stats = new ArrayList<PlanNodeStats>();
        for (PlanNodeId planNodeId : planNodeIds) {
            if (!planNodeInputPositions.containsKey(planNodeId)) continue;
            stats.add(new PlanNodeStats(planNodeId, new Duration((double)((Long)planNodeScheduledMillis.get(planNodeId)).longValue(), TimeUnit.MILLISECONDS), new Duration((double)((Long)planNodeCpuMillis.get(planNodeId)).longValue(), TimeUnit.MILLISECONDS), (Long)planNodeInputPositions.get(planNodeId), DataSize.succinctDataSize((double)((Long)planNodeInputBytes.get(planNodeId)).longValue(), (DataSize.Unit)DataSize.Unit.BYTE), planNodeOutputPositions.getOrDefault(planNodeId, 0L), DataSize.succinctDataSize((double)planNodeOutputBytes.getOrDefault(planNodeId, 0L).longValue(), (DataSize.Unit)DataSize.Unit.BYTE), (Map)operatorInputStats.get(planNodeId), operatorHashCollisionsStats.getOrDefault(planNodeId, Collections.emptyMap()), Optional.ofNullable(windowNodeStats.get(planNodeId))));
        }
        return stats;
    }
}

