/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.planPrinter.OperatorHashCollisionsStats;
import com.facebook.presto.sql.planner.planPrinter.OperatorInputStats;
import com.facebook.presto.sql.planner.planPrinter.WindowOperatorStats;
import com.facebook.presto.util.Mergeable;
import com.facebook.presto.util.MoreMaps;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Deprecated
public class PlanNodeStats
implements Mergeable<PlanNodeStats> {
    private final PlanNodeId planNodeId;
    private final Duration planNodeScheduledTime;
    private final Duration planNodeCpuTime;
    private final long planNodeInputPositions;
    private final DataSize planNodeInputDataSize;
    private final long planNodeOutputPositions;
    private final DataSize planNodeOutputDataSize;
    private final Map<String, OperatorInputStats> operatorInputStats;
    private final Map<String, OperatorHashCollisionsStats> operatorHashCollisionsStats;
    private final Optional<WindowOperatorStats> windowOperatorStats;

    PlanNodeStats(PlanNodeId planNodeId, Duration planNodeScheduledTime, Duration planNodeCpuTime, long planNodeInputPositions, DataSize planNodeInputDataSize, long planNodeOutputPositions, DataSize planNodeOutputDataSize, Map<String, OperatorInputStats> operatorInputStats, Map<String, OperatorHashCollisionsStats> operatorHashCollisionsStats, Optional<WindowOperatorStats> windowOperatorStats) {
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.planNodeScheduledTime = Objects.requireNonNull(planNodeScheduledTime, "planNodeScheduledTime is null");
        this.planNodeCpuTime = Objects.requireNonNull(planNodeCpuTime, "planNodeCpuTime is null");
        this.planNodeInputPositions = planNodeInputPositions;
        this.planNodeInputDataSize = planNodeInputDataSize;
        this.planNodeOutputPositions = planNodeOutputPositions;
        this.planNodeOutputDataSize = planNodeOutputDataSize;
        this.operatorInputStats = Objects.requireNonNull(operatorInputStats, "operatorInputStats is null");
        this.operatorHashCollisionsStats = Objects.requireNonNull(operatorHashCollisionsStats, "operatorHashCollisionsStats is null");
        this.windowOperatorStats = Objects.requireNonNull(windowOperatorStats, "windowOperatorStats is null");
    }

    private static double computedStdDev(double sumSquared, double sum, long n) {
        double average = sum / (double)n;
        double variance = (sumSquared - 2.0 * sum * average + average * average * (double)n) / (double)n;
        return Math.sqrt(Double.max(variance, 0.0));
    }

    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    public Duration getPlanNodeScheduledTime() {
        return this.planNodeScheduledTime;
    }

    public Duration getPlanNodeCpuTime() {
        return this.planNodeCpuTime;
    }

    public Set<String> getOperatorTypes() {
        return this.operatorInputStats.keySet();
    }

    public long getPlanNodeInputPositions() {
        return this.planNodeInputPositions;
    }

    public DataSize getPlanNodeInputDataSize() {
        return this.planNodeInputDataSize;
    }

    public long getPlanNodeOutputPositions() {
        return this.planNodeOutputPositions;
    }

    public DataSize getPlanNodeOutputDataSize() {
        return this.planNodeOutputDataSize;
    }

    public Map<String, Double> getOperatorInputPositionsAverages() {
        return this.operatorInputStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (double)((OperatorInputStats)entry.getValue()).getInputPositions() / (double)this.operatorInputStats.get(entry.getKey()).getTotalDrivers()));
    }

    public Map<String, Double> getOperatorInputPositionsStdDevs() {
        return this.operatorInputStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> PlanNodeStats.computedStdDev(((OperatorInputStats)entry.getValue()).getSumSquaredInputPositions(), ((OperatorInputStats)entry.getValue()).getInputPositions(), ((OperatorInputStats)entry.getValue()).getTotalDrivers())));
    }

    public Map<String, Double> getOperatorHashCollisionsAverages() {
        return this.operatorHashCollisionsStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OperatorHashCollisionsStats)entry.getValue()).getWeightedHashCollisions() / (double)this.operatorInputStats.get(entry.getKey()).getInputPositions()));
    }

    public Map<String, Double> getOperatorHashCollisionsStdDevs() {
        return this.operatorHashCollisionsStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> PlanNodeStats.computedWeightedStdDev(((OperatorHashCollisionsStats)entry.getValue()).getWeightedSumSquaredHashCollisions(), ((OperatorHashCollisionsStats)entry.getValue()).getWeightedHashCollisions(), this.operatorInputStats.get(entry.getKey()).getInputPositions())));
    }

    private static double computedWeightedStdDev(double sumSquared, double sum, double totalWeight) {
        double average = sum / totalWeight;
        double variance = (sumSquared - 2.0 * sum * average) / totalWeight + average * average;
        return Math.sqrt(Double.max(variance, 0.0));
    }

    public Map<String, Double> getOperatorExpectedCollisionsAverages() {
        return this.operatorHashCollisionsStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OperatorHashCollisionsStats)entry.getValue()).getWeightedExpectedHashCollisions() / (double)this.operatorInputStats.get(entry.getKey()).getInputPositions()));
    }

    public Optional<WindowOperatorStats> getWindowOperatorStats() {
        return this.windowOperatorStats;
    }

    @Override
    public PlanNodeStats mergeWith(PlanNodeStats other) {
        Preconditions.checkArgument((boolean)this.planNodeId.equals(other.getPlanNodeId()), (String)"planNodeIds do not match. %s != %s", (Object)this.planNodeId, (Object)other.getPlanNodeId());
        long planNodeInputPositions = this.planNodeInputPositions + other.planNodeInputPositions;
        DataSize planNodeInputDataSize = DataSize.succinctBytes((long)(this.planNodeInputDataSize.toBytes() + other.planNodeInputDataSize.toBytes()));
        long planNodeOutputPositions = this.planNodeOutputPositions + other.planNodeOutputPositions;
        DataSize planNodeOutputDataSize = DataSize.succinctBytes((long)(this.planNodeOutputDataSize.toBytes() + other.planNodeOutputDataSize.toBytes()));
        Map<String, OperatorInputStats> operatorInputStats = MoreMaps.mergeMaps(this.operatorInputStats, other.operatorInputStats, OperatorInputStats::merge);
        Map<String, OperatorHashCollisionsStats> operatorHashCollisionsStats = MoreMaps.mergeMaps(this.operatorHashCollisionsStats, other.operatorHashCollisionsStats, OperatorHashCollisionsStats::merge);
        Optional<WindowOperatorStats> windowNodeStats = Mergeable.merge(this.windowOperatorStats, other.windowOperatorStats);
        return new PlanNodeStats(this.planNodeId, new Duration((double)(this.planNodeScheduledTime.toMillis() + other.getPlanNodeScheduledTime().toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.planNodeCpuTime.toMillis() + other.getPlanNodeCpuTime().toMillis()), TimeUnit.MILLISECONDS), planNodeInputPositions, planNodeInputDataSize, planNodeOutputPositions, planNodeOutputDataSize, operatorInputStats, operatorHashCollisionsStats, windowNodeStats);
    }
}

