/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BeginTableWrite
implements PlanOptimizer {
    private final Metadata metadata;

    public BeginTableWrite(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(session), plan, new Context());
    }

    public static class Context {
        private Optional<TableWriterNode.WriterTarget> handle = Optional.empty();
        private Optional<TableWriterNode.WriterTarget> materializedHandle = Optional.empty();

        public void addMaterializedHandle(TableWriterNode.WriterTarget handle, TableWriterNode.WriterTarget materializedHandle) {
            Preconditions.checkState((!this.handle.isPresent() ? 1 : 0) != 0, (Object)"can only have one WriterTarget in a subtree");
            this.handle = Optional.of(handle);
            this.materializedHandle = Optional.of(materializedHandle);
        }

        public Optional<TableWriterNode.WriterTarget> getMaterializedHandle(TableWriterNode.WriterTarget handle) {
            Preconditions.checkState((boolean)this.handle.get().equals(handle), (Object)"can't find materialized handle for WriterTarget");
            return this.materializedHandle;
        }
    }

    private class Rewriter
    extends SimplePlanRewriter<Context> {
        private final Session session;

        public Rewriter(Session session) {
            this.session = session;
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            TableWriterNode.WriterTarget writerTarget = context.get().getMaterializedHandle(node.getTarget()).get();
            return new TableWriterNode(node.getId(), node.getSource().accept(this, context), writerTarget, node.getRowCountSymbol(), node.getFragmentSymbol(), node.getColumns(), node.getColumnNames(), node.getPartitioningScheme(), node.getStatisticsAggregation(), node.getStatisticsAggregationDescriptor());
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            TableWriterNode.DeleteHandle deleteHandle = (TableWriterNode.DeleteHandle)context.get().getMaterializedHandle(node.getTarget()).get();
            return new DeleteNode(node.getId(), this.rewriteDeleteTableScan(node.getSource(), deleteHandle.getHandle()), deleteHandle, node.getRowId(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            PlanNode child = node.getSource();
            TableWriterNode.WriterTarget originalTarget = this.getTarget(child);
            TableWriterNode.WriterTarget newTarget = this.createWriterTarget(originalTarget);
            context.get().addMaterializedHandle(originalTarget, newTarget);
            child = child.accept(this, context);
            return new TableFinishNode(node.getId(), child, newTarget, node.getRowCountSymbol(), node.getStatisticsAggregation(), node.getStatisticsAggregationDescriptor());
        }

        public TableWriterNode.WriterTarget getTarget(PlanNode node) {
            if (node instanceof TableWriterNode) {
                return ((TableWriterNode)node).getTarget();
            }
            if (node instanceof DeleteNode) {
                return ((DeleteNode)node).getTarget();
            }
            if (node instanceof ExchangeNode || node instanceof UnionNode) {
                Set writerTargets = node.getSources().stream().map(this::getTarget).collect(Collectors.toSet());
                return (TableWriterNode.WriterTarget)Iterables.getOnlyElement(writerTargets);
            }
            throw new IllegalArgumentException("Invalid child for TableCommitNode: " + node.getClass().getSimpleName());
        }

        private TableWriterNode.WriterTarget createWriterTarget(TableWriterNode.WriterTarget target) {
            if (target instanceof TableWriterNode.CreateName) {
                TableWriterNode.CreateName create = (TableWriterNode.CreateName)target;
                return new TableWriterNode.CreateHandle(BeginTableWrite.this.metadata.beginCreateTable(this.session, create.getCatalog(), create.getTableMetadata(), create.getLayout()), create.getTableMetadata().getTable());
            }
            if (target instanceof TableWriterNode.InsertReference) {
                TableWriterNode.InsertReference insert = (TableWriterNode.InsertReference)target;
                return new TableWriterNode.InsertHandle(BeginTableWrite.this.metadata.beginInsert(this.session, insert.getHandle()), BeginTableWrite.this.metadata.getTableMetadata(this.session, insert.getHandle()).getTable());
            }
            if (target instanceof TableWriterNode.DeleteHandle) {
                TableWriterNode.DeleteHandle delete = (TableWriterNode.DeleteHandle)target;
                return new TableWriterNode.DeleteHandle(BeginTableWrite.this.metadata.beginDelete(this.session, delete.getHandle()), delete.getSchemaTableName());
            }
            throw new IllegalArgumentException("Unhandled target type: " + target.getClass().getSimpleName());
        }

        private PlanNode rewriteDeleteTableScan(PlanNode node, TableHandle handle) {
            JoinNode joinNode;
            if (node instanceof TableScanNode) {
                TableScanNode scan = (TableScanNode)node;
                TupleDomain<ColumnHandle> originalEnforcedConstraint = scan.getEnforcedConstraint();
                List<TableLayoutResult> layouts = BeginTableWrite.this.metadata.getLayouts(this.session, handle, (Constraint<ColumnHandle>)new Constraint(originalEnforcedConstraint), Optional.of(ImmutableSet.copyOf(scan.getAssignments().values())));
                Verify.verify((layouts.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one layout for delete", (Object[])new Object[0]);
                TableLayoutResult layoutResult = (TableLayoutResult)Iterables.getOnlyElement(layouts);
                return new TableScanNode(scan.getId(), handle, scan.getOutputSymbols(), scan.getAssignments(), Optional.of(layoutResult.getLayout().getHandle()), layoutResult.getLayout().getPredicate(), TableLayoutResult.computeEnforced(originalEnforcedConstraint, layoutResult.getUnenforcedConstraint()));
            }
            if (node instanceof FilterNode) {
                PlanNode source = this.rewriteDeleteTableScan(((FilterNode)node).getSource(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
            }
            if (node instanceof ProjectNode) {
                PlanNode source = this.rewriteDeleteTableScan(((ProjectNode)node).getSource(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
            }
            if (node instanceof SemiJoinNode) {
                PlanNode source = this.rewriteDeleteTableScan(((SemiJoinNode)node).getSource(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source, (Object)((SemiJoinNode)node).getFilteringSource()));
            }
            if (node instanceof JoinNode && (joinNode = (JoinNode)node).getType() == JoinNode.Type.INNER && QueryCardinalityUtil.isAtMostScalar(joinNode.getRight())) {
                PlanNode source = this.rewriteDeleteTableScan(joinNode.getLeft(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source, (Object)joinNode.getRight()));
            }
            throw new IllegalArgumentException("Invalid descendant for DeleteNode: " + node.getClass().getName());
        }
    }
}

