/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.geospatial.KdbTree;
import com.facebook.presto.geospatial.KdbTreeUtils;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.ExpressionNodeInliner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.SpatialJoinUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.MoreFutures;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;

public class ExtractSpatialJoins {
    private static final TypeSignature GEOMETRY_TYPE_SIGNATURE = TypeSignature.parseTypeSignature((String)"Geometry");
    private static final String KDB_TREE_TYPENAME = "KdbTree";
    private final Metadata metadata;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;

    public ExtractSpatialJoins(Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceManager = Objects.requireNonNull(pageSourceManager, "pageSourceManager is null");
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of((Object)new ExtractSpatialInnerJoin(this.metadata, this.splitManager, this.pageSourceManager), (Object)new ExtractSpatialLeftJoin(this.metadata, this.splitManager, this.pageSourceManager));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Rule.Result tryCreateSpatialJoin(Rule.Context context, JoinNode joinNode, Expression filter, PlanNodeId nodeId, List<Symbol> outputSymbols, ComparisonExpression spatialComparison, Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
        ComparisonExpression newComparison;
        Optional<Symbol> newRadiusSymbol;
        Set<Symbol> radiusSymbols;
        Expression radius;
        PlanNode leftNode = joinNode.getLeft();
        PlanNode rightNode = joinNode.getRight();
        List<Symbol> leftSymbols = leftNode.getOutputSymbols();
        List<Symbol> rightSymbols = rightNode.getOutputSymbols();
        if (spatialComparison.getOperator() == ComparisonExpression.Operator.LESS_THAN || spatialComparison.getOperator() == ComparisonExpression.Operator.LESS_THAN_OR_EQUAL) {
            radius = spatialComparison.getRight();
            radiusSymbols = SymbolsExtractor.extractUnique(radius);
            if (!radiusSymbols.isEmpty() && (!rightSymbols.containsAll(radiusSymbols) || !ExtractSpatialJoins.containsNone(leftSymbols, radiusSymbols))) return Rule.Result.empty();
            newRadiusSymbol = ExtractSpatialJoins.newRadiusSymbol(context, radius);
            newComparison = new ComparisonExpression(spatialComparison.getOperator(), spatialComparison.getLeft(), ExtractSpatialJoins.toExpression(newRadiusSymbol, radius));
        } else {
            radius = spatialComparison.getLeft();
            radiusSymbols = SymbolsExtractor.extractUnique(radius);
            if (!radiusSymbols.isEmpty() && (!rightSymbols.containsAll(radiusSymbols) || !ExtractSpatialJoins.containsNone(leftSymbols, radiusSymbols))) return Rule.Result.empty();
            newRadiusSymbol = ExtractSpatialJoins.newRadiusSymbol(context, radius);
            newComparison = new ComparisonExpression(spatialComparison.getOperator().flip(), spatialComparison.getRight(), ExtractSpatialJoins.toExpression(newRadiusSymbol, radius));
        }
        Expression newFilter = ExpressionNodeInliner.replaceExpression(filter, (Map<? extends Expression, ? extends Expression>)ImmutableMap.of((Object)spatialComparison, (Object)newComparison));
        PlanNode newRightNode = newRadiusSymbol.map(symbol -> ExtractSpatialJoins.addProjection(context, rightNode, symbol, radius)).orElse(rightNode);
        JoinNode newJoinNode = new JoinNode(joinNode.getId(), joinNode.getType(), leftNode, newRightNode, joinNode.getCriteria(), joinNode.getOutputSymbols(), Optional.of(newFilter), joinNode.getLeftHashSymbol(), joinNode.getRightHashSymbol(), joinNode.getDistributionType());
        return ExtractSpatialJoins.tryCreateSpatialJoin(context, newJoinNode, newFilter, nodeId, outputSymbols, (FunctionCall)newComparison.getLeft(), Optional.of(newComparison.getRight()), metadata, splitManager, pageSourceManager);
    }

    private static Rule.Result tryCreateSpatialJoin(Rule.Context context, JoinNode joinNode, Expression filter, PlanNodeId nodeId, List<Symbol> outputSymbols, FunctionCall spatialFunction, Optional<Expression> radius, Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
        PlanNode newRightNode;
        PlanNode newLeftNode;
        Optional<String> spatialPartitioningTableName = joinNode.getType() == JoinNode.Type.INNER ? SystemSessionProperties.getSpatialPartitioningTableName(context.getSession()) : Optional.empty();
        Optional<KdbTree> kdbTree = spatialPartitioningTableName.map(tableName -> ExtractSpatialJoins.loadKdbTree(tableName, context.getSession(), metadata, splitManager, pageSourceManager));
        List arguments = spatialFunction.getArguments();
        Verify.verify((arguments.size() == 2 ? 1 : 0) != 0);
        Expression firstArgument = (Expression)arguments.get(0);
        Expression secondArgument = (Expression)arguments.get(1);
        Set<Symbol> firstSymbols = SymbolsExtractor.extractUnique(firstArgument);
        Set<Symbol> secondSymbols = SymbolsExtractor.extractUnique(secondArgument);
        if (firstSymbols.isEmpty() || secondSymbols.isEmpty()) {
            return Rule.Result.empty();
        }
        Optional<Symbol> newFirstSymbol = ExtractSpatialJoins.newGeometrySymbol(context, firstArgument, metadata);
        Optional<Symbol> newSecondSymbol = ExtractSpatialJoins.newGeometrySymbol(context, secondArgument, metadata);
        PlanNode leftNode = joinNode.getLeft();
        PlanNode rightNode = joinNode.getRight();
        int alignment = ExtractSpatialJoins.checkAlignment(joinNode, firstSymbols, secondSymbols);
        if (alignment > 0) {
            newLeftNode = newFirstSymbol.map(symbol -> ExtractSpatialJoins.addProjection(context, leftNode, symbol, firstArgument)).orElse(leftNode);
            newRightNode = newSecondSymbol.map(symbol -> ExtractSpatialJoins.addProjection(context, rightNode, symbol, secondArgument)).orElse(rightNode);
        } else if (alignment < 0) {
            newLeftNode = newSecondSymbol.map(symbol -> ExtractSpatialJoins.addProjection(context, leftNode, symbol, secondArgument)).orElse(leftNode);
            newRightNode = newFirstSymbol.map(symbol -> ExtractSpatialJoins.addProjection(context, rightNode, symbol, firstArgument)).orElse(rightNode);
        } else {
            return Rule.Result.empty();
        }
        Expression newFirstArgument = ExtractSpatialJoins.toExpression(newFirstSymbol, firstArgument);
        Expression newSecondArgument = ExtractSpatialJoins.toExpression(newSecondSymbol, secondArgument);
        Optional<Object> leftPartitionSymbol = Optional.empty();
        Optional<Symbol> rightPartitionSymbol = Optional.empty();
        if (kdbTree.isPresent()) {
            leftPartitionSymbol = Optional.of(context.getSymbolAllocator().newSymbol("pid", (Type)IntegerType.INTEGER));
            rightPartitionSymbol = Optional.of(context.getSymbolAllocator().newSymbol("pid", (Type)IntegerType.INTEGER));
            if (alignment > 0) {
                newLeftNode = ExtractSpatialJoins.addPartitioningNodes(context, newLeftNode, (Symbol)leftPartitionSymbol.get(), kdbTree.get(), newFirstArgument, Optional.empty());
                newRightNode = ExtractSpatialJoins.addPartitioningNodes(context, newRightNode, rightPartitionSymbol.get(), kdbTree.get(), newSecondArgument, radius);
            } else {
                newLeftNode = ExtractSpatialJoins.addPartitioningNodes(context, newLeftNode, (Symbol)leftPartitionSymbol.get(), kdbTree.get(), newSecondArgument, Optional.empty());
                newRightNode = ExtractSpatialJoins.addPartitioningNodes(context, newRightNode, rightPartitionSymbol.get(), kdbTree.get(), newFirstArgument, radius);
            }
        }
        FunctionCall newSpatialFunction = new FunctionCall(spatialFunction.getName(), (List)ImmutableList.of((Object)newFirstArgument, (Object)newSecondArgument));
        Expression newFilter = ExpressionNodeInliner.replaceExpression(filter, (Map<? extends Expression, ? extends Expression>)ImmutableMap.of((Object)spatialFunction, (Object)newSpatialFunction));
        return Rule.Result.ofPlanNode(new SpatialJoinNode(nodeId, SpatialJoinNode.Type.fromJoinNodeType(joinNode.getType()), newLeftNode, newRightNode, outputSymbols, newFilter, leftPartitionSymbol, rightPartitionSymbol, kdbTree.map(KdbTreeUtils::toJson)));
    }

    private static KdbTree loadKdbTree(String tableName, Session session, Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
        QualifiedObjectName name = ExtractSpatialJoins.toQualifiedObjectName(tableName, session.getCatalog().get(), session.getSchema().get());
        TableHandle tableHandle = metadata.getTableHandle(session, name).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SPATIAL_PARTITIONING, String.format("Table not found: %s", name)));
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle);
        List visibleColumnHandles = (List)columnHandles.values().stream().filter(handle -> !metadata.getColumnMetadata(session, tableHandle, (ColumnHandle)handle).isHidden()).collect(ImmutableList.toImmutableList());
        ExtractSpatialJoins.checkSpatialPartitioningTable(visibleColumnHandles.size() == 1, "Expected single column for table %s, but found %s columns", name, columnHandles.size());
        ColumnHandle kdbTreeColumn = (ColumnHandle)Iterables.getOnlyElement((Iterable)visibleColumnHandles);
        List<TableLayoutResult> layouts = metadata.getLayouts(session, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.of(ImmutableSet.of((Object)kdbTreeColumn)));
        ExtractSpatialJoins.checkSpatialPartitioningTable(!layouts.isEmpty(), "Table is empty: %s", name);
        Optional<Object> kdbTree = Optional.empty();
        try (SplitSource splitSource = splitManager.getSplits(session, layouts.get(0).getLayout().getHandle(), ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING);){
            while (!Thread.currentThread().isInterrupted()) {
                SplitSource.SplitBatch splitBatch = (SplitSource.SplitBatch)MoreFutures.getFutureValue(splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, Lifespan.taskWide(), 1000));
                List<Split> splits = splitBatch.getSplits();
                for (Split split : splits) {
                    try {
                        ConnectorPageSource pageSource = pageSourceManager.createPageSource(session, split, (List<ColumnHandle>)ImmutableList.of((Object)kdbTreeColumn));
                        Throwable throwable = null;
                        try {
                            do {
                                MoreFutures.getFutureValue((Future)pageSource.isBlocked());
                                Page page = pageSource.getNextPage();
                                if (page == null || page.getPositionCount() <= 0) continue;
                                ExtractSpatialJoins.checkSpatialPartitioningTable(!kdbTree.isPresent(), "Expected exactly one row for table %s, but found more", name);
                                ExtractSpatialJoins.checkSpatialPartitioningTable(page.getPositionCount() == 1, "Expected exactly one row for table %s, but found %s rows", name, page.getPositionCount());
                                String kdbTreeJson = VarcharType.VARCHAR.getSlice(page.getBlock(0), 0).toStringUtf8();
                                try {
                                    kdbTree = Optional.of(KdbTreeUtils.fromJson((String)kdbTreeJson));
                                }
                                catch (IllegalArgumentException e) {
                                    ExtractSpatialJoins.checkSpatialPartitioningTable(false, "Invalid JSON string for KDB tree: %s", e.getMessage());
                                }
                            } while (!pageSource.isFinished());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (pageSource == null) continue;
                            if (throwable != null) {
                                try {
                                    pageSource.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            pageSource.close();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                if (!splitBatch.isLastBatch()) continue;
                break;
            }
        }
        ExtractSpatialJoins.checkSpatialPartitioningTable(kdbTree.isPresent(), "Expected exactly one row for table %s, but got none", name);
        return (KdbTree)kdbTree.get();
    }

    private static void checkSpatialPartitioningTable(boolean condition, String message, Object ... arguments) {
        if (!condition) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SPATIAL_PARTITIONING, String.format(message, arguments));
        }
    }

    private static QualifiedObjectName toQualifiedObjectName(String name, String catalog, String schema) {
        ImmutableList ids = ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split((CharSequence)name));
        if (ids.size() == 3) {
            return new QualifiedObjectName((String)ids.get(0), (String)ids.get(1), (String)ids.get(2));
        }
        if (ids.size() == 2) {
            return new QualifiedObjectName(catalog, (String)ids.get(0), (String)ids.get(1));
        }
        if (ids.size() == 1) {
            return new QualifiedObjectName(catalog, schema, (String)ids.get(0));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SPATIAL_PARTITIONING, String.format("Invalid name: %s", name));
    }

    private static int checkAlignment(JoinNode joinNode, Set<Symbol> maybeLeftSymbols, Set<Symbol> maybeRightSymbols) {
        List<Symbol> leftSymbols = joinNode.getLeft().getOutputSymbols();
        List<Symbol> rightSymbols = joinNode.getRight().getOutputSymbols();
        if (leftSymbols.containsAll(maybeLeftSymbols) && ExtractSpatialJoins.containsNone(leftSymbols, maybeRightSymbols) && rightSymbols.containsAll(maybeRightSymbols) && ExtractSpatialJoins.containsNone(rightSymbols, maybeLeftSymbols)) {
            return 1;
        }
        if (leftSymbols.containsAll(maybeRightSymbols) && ExtractSpatialJoins.containsNone(leftSymbols, maybeLeftSymbols) && rightSymbols.containsAll(maybeLeftSymbols) && ExtractSpatialJoins.containsNone(rightSymbols, maybeRightSymbols)) {
            return -1;
        }
        return 0;
    }

    private static Expression toExpression(Optional<Symbol> optionalSymbol, Expression defaultExpression) {
        return optionalSymbol.map(symbol -> symbol.toSymbolReference()).orElse(defaultExpression);
    }

    private static Optional<Symbol> newGeometrySymbol(Rule.Context context, Expression expression, Metadata metadata) {
        if (expression instanceof SymbolReference) {
            return Optional.empty();
        }
        return Optional.of(context.getSymbolAllocator().newSymbol(expression, metadata.getType(GEOMETRY_TYPE_SIGNATURE)));
    }

    private static Optional<Symbol> newRadiusSymbol(Rule.Context context, Expression expression) {
        if (expression instanceof SymbolReference) {
            return Optional.empty();
        }
        return Optional.of(context.getSymbolAllocator().newSymbol(expression, (Type)DoubleType.DOUBLE));
    }

    private static PlanNode addProjection(Rule.Context context, PlanNode node, Symbol symbol, Expression expression) {
        Assignments.Builder projections = Assignments.builder();
        for (Symbol outputSymbol : node.getOutputSymbols()) {
            projections.putIdentity(outputSymbol);
        }
        projections.put(symbol, expression);
        return new ProjectNode(context.getIdAllocator().getNextId(), node, projections.build());
    }

    private static PlanNode addPartitioningNodes(Rule.Context context, PlanNode node, Symbol partitionSymbol, KdbTree kdbTree, Expression geometry, Optional<Expression> radius) {
        Assignments.Builder projections = Assignments.builder();
        for (Symbol outputSymbol : node.getOutputSymbols()) {
            projections.putIdentity(outputSymbol);
        }
        ImmutableList.Builder partitioningArguments = ImmutableList.builder().add((Object)new Cast((Expression)new StringLiteral(KdbTreeUtils.toJson((KdbTree)kdbTree)), KDB_TREE_TYPENAME)).add((Object)geometry);
        radius.map(arg_0 -> ((ImmutableList.Builder)partitioningArguments).add(arg_0));
        FunctionCall partitioningFunction = new FunctionCall(QualifiedName.of((String)"spatial_partitions"), (List)partitioningArguments.build());
        Symbol partitionsSymbol = context.getSymbolAllocator().newSymbol((Expression)partitioningFunction, (Type)new ArrayType((Type)IntegerType.INTEGER));
        projections.put(partitionsSymbol, (Expression)partitioningFunction);
        return new UnnestNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), node, projections.build()), node.getOutputSymbols(), (Map<Symbol, List<Symbol>>)ImmutableMap.of((Object)partitionsSymbol, (Object)ImmutableList.of((Object)partitionSymbol)), Optional.empty());
    }

    private static boolean containsNone(Collection<Symbol> values, Collection<Symbol> testValues) {
        return values.stream().noneMatch(arg_0 -> ((ImmutableSet)ImmutableSet.copyOf(testValues)).contains(arg_0));
    }

    @VisibleForTesting
    public static final class ExtractSpatialLeftJoin
    implements Rule<JoinNode> {
        private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(node -> node.getCriteria().isEmpty() && node.getFilter().isPresent() && node.getType() == JoinNode.Type.LEFT);
        private final Metadata metadata;
        private final SplitManager splitManager;
        private final PageSourceManager pageSourceManager;

        public ExtractSpatialLeftJoin(Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.pageSourceManager = Objects.requireNonNull(pageSourceManager, "pageSourceManager is null");
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isSpatialJoinEnabled(session);
        }

        @Override
        public Pattern<JoinNode> getPattern() {
            return PATTERN;
        }

        @Override
        public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
            Expression filter = joinNode.getFilter().get();
            List<FunctionCall> spatialFunctions = SpatialJoinUtils.extractSupportedSpatialFunctions(filter);
            for (FunctionCall spatialFunction : spatialFunctions) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, joinNode.getId(), joinNode.getOutputSymbols(), spatialFunction, Optional.empty(), this.metadata, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            List<ComparisonExpression> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filter);
            for (ComparisonExpression spatialComparison : spatialComparisons) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, joinNode.getId(), joinNode.getOutputSymbols(), spatialComparison, this.metadata, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            return Rule.Result.empty();
        }
    }

    @VisibleForTesting
    public static final class ExtractSpatialInnerJoin
    implements Rule<FilterNode> {
        private static final Capture<JoinNode> JOIN = Capture.newCapture();
        private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.join().capturedAs(JOIN).matching(JoinNode::isCrossJoin)));
        private final Metadata metadata;
        private final SplitManager splitManager;
        private final PageSourceManager pageSourceManager;

        public ExtractSpatialInnerJoin(Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.pageSourceManager = Objects.requireNonNull(pageSourceManager, "pageSourceManager is null");
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isSpatialJoinEnabled(session);
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return PATTERN;
        }

        @Override
        public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
            JoinNode joinNode = (JoinNode)captures.get(JOIN);
            Expression filter = node.getPredicate();
            List<FunctionCall> spatialFunctions = SpatialJoinUtils.extractSupportedSpatialFunctions(filter);
            for (FunctionCall spatialFunction : spatialFunctions) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, node.getId(), node.getOutputSymbols(), spatialFunction, Optional.empty(), this.metadata, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            List<ComparisonExpression> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filter);
            for (ComparisonExpression spatialComparison : spatialComparisons) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, node.getId(), node.getOutputSymbols(), spatialComparison, this.metadata, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            return Rule.Result.empty();
        }
    }
}

