/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.FixedBucketNodeMap;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.Node;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

public class NodePartitionMap {
    private final List<Node> partitionToNode;
    private final int[] bucketToPartition;
    private final ToIntFunction<Split> splitToBucket;

    public NodePartitionMap(List<Node> partitionToNode, ToIntFunction<Split> splitToBucket) {
        this.partitionToNode = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionToNode, "partitionToNode is null"));
        this.bucketToPartition = IntStream.range(0, partitionToNode.size()).toArray();
        this.splitToBucket = Objects.requireNonNull(splitToBucket, "splitToBucket is null");
    }

    public NodePartitionMap(List<Node> partitionToNode, int[] bucketToPartition, ToIntFunction<Split> splitToBucket) {
        this.bucketToPartition = Objects.requireNonNull(bucketToPartition, "bucketToPartition is null");
        this.partitionToNode = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionToNode, "partitionToNode is null"));
        this.splitToBucket = Objects.requireNonNull(splitToBucket, "splitToBucket is null");
    }

    public List<Node> getPartitionToNode() {
        return this.partitionToNode;
    }

    public int[] getBucketToPartition() {
        return this.bucketToPartition;
    }

    public Node getNode(Split split) {
        int bucket = this.splitToBucket.applyAsInt(split);
        int partition = this.bucketToPartition[bucket];
        return Objects.requireNonNull(this.partitionToNode.get(partition));
    }

    public BucketNodeMap asBucketNodeMap() {
        ImmutableList.Builder bucketToNode = ImmutableList.builder();
        for (int partition : this.bucketToPartition) {
            bucketToNode.add((Object)this.partitionToNode.get(partition));
        }
        return new FixedBucketNodeMap(this.splitToBucket, (List<Node>)bucketToNode.build());
    }
}

