/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.block.BlockSerdeUtil;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.VarbinaryFunctions;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.SliceUtf8;
import java.util.List;
import java.util.Objects;

public final class LiteralEncoder {
    private final BlockEncodingSerde blockEncodingSerde;

    public LiteralEncoder(BlockEncodingSerde blockEncodingSerde) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
    }

    public List<Expression> toExpressions(List<?> objects, List<? extends Type> types) {
        Objects.requireNonNull(objects, "objects is null");
        Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument((objects.size() == types.size() ? 1 : 0) != 0, (Object)"objects and types do not have the same size");
        ImmutableList.Builder expressions = ImmutableList.builder();
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            Type type = types.get(i);
            expressions.add((Object)this.toExpression(object, type));
        }
        return expressions.build();
    }

    public Expression toExpression(Object object, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (object instanceof Expression) {
            return (Expression)object;
        }
        if (object == null) {
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                return new NullLiteral();
            }
            return new Cast((Expression)new NullLiteral(), type.getTypeSignature().toString(), false, true);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return new GenericLiteral("TINYINT", object.toString());
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return new GenericLiteral("SMALLINT", object.toString());
        }
        if (type.equals(IntegerType.INTEGER)) {
            return new LongLiteral(object.toString());
        }
        if (type.equals(BigintType.BIGINT)) {
            LongLiteral expression = new LongLiteral(object.toString());
            if (expression.getValue() >= Integer.MIN_VALUE && expression.getValue() <= Integer.MAX_VALUE) {
                return new GenericLiteral("BIGINT", object.toString());
            }
            return new LongLiteral(object.toString());
        }
        Preconditions.checkArgument((boolean)Primitives.wrap((Class)type.getJavaType()).isInstance(object), (String)"object.getClass (%s) and type.getJavaType (%s) do not agree", object.getClass(), (Object)type.getJavaType());
        if (type.equals(DoubleType.DOUBLE)) {
            Double value = (Double)object;
            if (value.isNaN()) {
                return new FunctionCall(QualifiedName.of((String)"nan"), (List)ImmutableList.of());
            }
            if (value.equals(Double.NEGATIVE_INFINITY)) {
                return ArithmeticUnaryExpression.negative((Expression)new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of()));
            }
            if (value.equals(Double.POSITIVE_INFINITY)) {
                return new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of());
            }
            return new DoubleLiteral(object.toString());
        }
        if (type.equals(RealType.REAL)) {
            Float value = Float.valueOf(Float.intBitsToFloat(((Long)object).intValue()));
            if (value.isNaN()) {
                return new Cast((Expression)new FunctionCall(QualifiedName.of((String)"nan"), (List)ImmutableList.of()), "real");
            }
            if (value.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                return ArithmeticUnaryExpression.negative((Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of()), "real"));
            }
            if (value.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                return new Cast((Expression)new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of()), "real");
            }
            return new GenericLiteral("REAL", value.toString());
        }
        if (type instanceof DecimalType) {
            String string = Decimals.isShortDecimal((Type)type) ? Decimals.toString((long)((Long)object), (int)((DecimalType)type).getScale()) : Decimals.toString((Slice)((Slice)object), (int)((DecimalType)type).getScale());
            return new Cast((Expression)new DecimalLiteral(string), type.getDisplayName());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Slice value = (Slice)object;
            StringLiteral stringLiteral = new StringLiteral(value.toStringUtf8());
            if (!varcharType.isUnbounded() && varcharType.getLengthSafe() == SliceUtf8.countCodePoints((Slice)value)) {
                return stringLiteral;
            }
            return new Cast((Expression)stringLiteral, type.getDisplayName(), false, true);
        }
        if (type instanceof CharType) {
            StringLiteral stringLiteral = new StringLiteral(((Slice)object).toStringUtf8());
            return new Cast((Expression)stringLiteral, type.getDisplayName(), false, true);
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanLiteral(object.toString());
        }
        if (type.equals(DateType.DATE)) {
            return new GenericLiteral("DATE", new SqlDate(Math.toIntExact((Long)object)).toString());
        }
        if (object instanceof Block) {
            DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(((Block)object).getSizeInBytes()));
            BlockSerdeUtil.writeBlock(this.blockEncodingSerde, (SliceOutput)output, (Block)object);
            object = output.slice();
        }
        if (object instanceof Slice) {
            FunctionCall fromBase64 = new FunctionCall(QualifiedName.of((String)"from_base64"), (List)ImmutableList.of((Object)new StringLiteral(VarbinaryFunctions.toBase64((Slice)object).toStringUtf8())));
            Signature signature = FunctionRegistry.getMagicLiteralFunctionSignature(type);
            return new FunctionCall(QualifiedName.of((String)signature.getName()), (List)ImmutableList.of((Object)fromBase64));
        }
        Signature signature = FunctionRegistry.getMagicLiteralFunctionSignature(type);
        Expression rawLiteral = this.toExpression(object, FunctionRegistry.typeForMagicLiteral(type));
        return new FunctionCall(QualifiedName.of((String)signature.getName()), (List)ImmutableList.of((Object)rawLiteral));
    }
}

