/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.InstructionNode;
import io.airlift.bytecode.instruction.LabelNode;
import io.airlift.bytecode.instruction.VariableInstruction;
import java.util.List;

public class SwitchCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        BytecodeNode elseValue;
        List<RowExpression> whenClauses;
        Scope scope = generatorContext.getScope();
        RowExpression value = arguments.get(0);
        BytecodeNode valueBytecode = generatorContext.generate(value);
        RowExpression last = arguments.get(arguments.size() - 1);
        if (last instanceof CallExpression && ((CallExpression)last).getSignature().getName().equals("WHEN")) {
            whenClauses = arguments.subList(1, arguments.size());
            elseValue = new BytecodeBlock().append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantTrue())).pushJavaDefault(returnType.getJavaType());
        } else {
            whenClauses = arguments.subList(1, arguments.size() - 1);
            elseValue = generatorContext.generate(last);
        }
        Class valueType = value.getType().getJavaType();
        LabelNode nullValue = new LabelNode("nullCondition");
        Variable tempVariable = scope.createTempVariable(valueType);
        BytecodeBlock block = new BytecodeBlock().append(valueBytecode).append(BytecodeUtils.ifWasNullClearPopAndGoto(scope, nullValue, Void.TYPE, valueType)).putVariable(tempVariable);
        InstructionNode getTempVariableNode = VariableInstruction.loadVariable((Variable)tempVariable);
        elseValue = new BytecodeBlock().visitLabel(nullValue).append(elseValue);
        for (RowExpression clause : Lists.reverse(whenClauses)) {
            Preconditions.checkArgument((clause instanceof CallExpression && ((CallExpression)clause).getSignature().getName().equals("WHEN") ? 1 : 0) != 0);
            RowExpression operand = ((CallExpression)clause).getArguments().get(0);
            RowExpression result = ((CallExpression)clause).getArguments().get(1);
            Signature equalsFunction = generatorContext.getRegistry().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)value.getType(), (Object)operand.getType()));
            BytecodeNode equalsCall = generatorContext.generateCall(equalsFunction.getName(), generatorContext.getRegistry().getScalarFunctionImplementation(equalsFunction), (List<BytecodeNode>)ImmutableList.of((Object)generatorContext.generate(operand), (Object)getTempVariableNode));
            BytecodeBlock condition = new BytecodeBlock().append(equalsCall).append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantFalse()));
            elseValue = new IfStatement("when", new Object[0]).condition((BytecodeNode)condition).ifTrue(generatorContext.generate(result)).ifFalse(elseValue);
        }
        return block.append(elseValue);
    }
}

