/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.InternalJoinFilterFunction;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.StandardJoinFilterFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.facebook.presto.sql.gen.IsolatedClass;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.LambdaExpressionExtractor;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.util.CompilerUtils;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JoinFilterFunctionCompiler {
    private final Metadata metadata;
    private final LoadingCache<JoinFilterCacheKey, JoinFilterFunctionFactory> joinFilterFunctionFactories = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).build(CacheLoader.from(key -> this.internalCompileFilterFunctionFactory(key.getFilter(), key.getLeftBlocksSize())));

    @Inject
    public JoinFilterFunctionCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Managed
    @Nested
    public CacheStatsMBean getJoinFilterFunctionFactoryStats() {
        return new CacheStatsMBean(this.joinFilterFunctionFactories);
    }

    public JoinFilterFunctionFactory compileJoinFilterFunction(RowExpression filter, int leftBlocksSize) {
        return (JoinFilterFunctionFactory)this.joinFilterFunctionFactories.getUnchecked((Object)new JoinFilterCacheKey(filter, leftBlocksSize));
    }

    private JoinFilterFunctionFactory internalCompileFilterFunctionFactory(RowExpression filterExpression, int leftBlocksSize) {
        Class<? extends InternalJoinFilterFunction> internalJoinFilterFunction = this.compileInternalJoinFilterFunction(filterExpression, leftBlocksSize);
        return new IsolatedJoinFilterFunctionFactory(internalJoinFilterFunction);
    }

    private Class<? extends InternalJoinFilterFunction> compileInternalJoinFilterFunction(RowExpression filterExpression, int leftBlocksSize) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("JoinFilterFunction"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(InternalJoinFilterFunction.class)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        new JoinFilterFunctionCompiler(this.metadata).generateMethods(classDefinition, callSiteBinder, filterExpression, leftBlocksSize);
        JoinFilterFunctionCompiler.generateToString(classDefinition, callSiteBinder, MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filterExpression).add("leftBlocksSize", leftBlocksSize).toString());
        return CompilerUtils.defineClass(classDefinition, InternalJoinFilterFunction.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, int leftBlocksSize) {
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        FieldDefinition sessionField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "session", ConnectorSession.class);
        Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap = this.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, leftBlocksSize, filter);
        this.generateFilterMethod(classDefinition, callSiteBinder, cachedInstanceBinder, compiledLambdaMap, filter, leftBlocksSize, sessionField);
        JoinFilterFunctionCompiler.generateConstructor(classDefinition, sessionField, cachedInstanceBinder);
    }

    private static void generateConstructor(ClassDefinition classDefinition, FieldDefinition sessionField, CachedInstanceBinder cachedInstanceBinder) {
        Parameter sessionParameter = Parameter.arg((String)"session", ConnectorSession.class);
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{sessionParameter});
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        body.append((BytecodeNode)thisVariable.setField(sessionField, (BytecodeExpression)sessionParameter));
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        body.ret();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, RowExpression filter, int leftBlocksSize, FieldDefinition sessionField) {
        Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
        Parameter leftPage = Parameter.arg((String)"leftPage", Page.class);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter rightPage = Parameter.arg((String)"rightPage", Page.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.builder().add((Object)leftPosition).add((Object)leftPage).add((Object)rightPosition).add((Object)rightPage).build());
        method.comment("filter: %s", new Object[]{filter.toString()});
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        scope.declareVariable("session", body, method.getThis().getField(sessionField));
        RowExpressionCompiler compiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, JoinFilterFunctionCompiler.fieldReferenceCompiler(callSiteBinder, (Variable)leftPosition, (Variable)leftPage, (Variable)rightPosition, (Variable)rightPage, leftBlocksSize), this.metadata.getFunctionRegistry(), compiledLambdaMap);
        BytecodeNode visitorBody = compiler.compile(filter, scope);
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        body.append(visitorBody).putVariable(result).append((BytecodeNode)new IfStatement().condition((BytecodeNode)wasNullVariable).ifTrue((BytecodeNode)BytecodeExpressions.constantFalse().ret()).ifFalse((BytecodeNode)result.ret()));
    }

    private Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, int leftBlocksSize, RowExpression filter) {
        ImmutableSet lambdaExpressions = ImmutableSet.copyOf(LambdaExpressionExtractor.extractLambdaExpressions(filter));
        ImmutableMap.Builder compiledLambdaMap = ImmutableMap.builder();
        int counter = 0;
        for (LambdaDefinitionExpression lambdaExpression : lambdaExpressions) {
            LambdaBytecodeGenerator.CompiledLambda compiledLambda = LambdaBytecodeGenerator.preGenerateLambdaExpression(lambdaExpression, "lambda_" + counter, containerClassDefinition, (Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda>)compiledLambdaMap.build(), callSiteBinder, cachedInstanceBinder, this.metadata.getFunctionRegistry());
            compiledLambdaMap.put((Object)lambdaExpression, (Object)compiledLambda);
            ++counter;
        }
        return compiledLambdaMap.build();
    }

    private static void generateToString(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String string) {
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(string, String.class), "toString")).retObject();
    }

    private static RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler(CallSiteBinder callSiteBinder, Variable leftPosition, Variable leftPage, Variable rightPosition, Variable rightPage, int leftBlocksSize) {
        return new InputReferenceCompiler((scope, field) -> {
            if (field < leftBlocksSize) {
                return leftPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)field)});
            }
            return rightPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)(field - leftBlocksSize))});
        }, (scope, field) -> field < leftBlocksSize ? leftPosition : rightPosition, callSiteBinder);
    }

    private static class IsolatedJoinFilterFunctionFactory
    implements JoinFilterFunctionFactory {
        private final Constructor<? extends InternalJoinFilterFunction> internalJoinFilterFunctionConstructor;
        private final Constructor<? extends JoinFilterFunction> isolatedJoinFilterFunctionConstructor;

        public IsolatedJoinFilterFunctionFactory(Class<? extends InternalJoinFilterFunction> internalJoinFilterFunction) {
            try {
                this.internalJoinFilterFunctionConstructor = internalJoinFilterFunction.getConstructor(ConnectorSession.class);
                Class<StandardJoinFilterFunction> isolatedJoinFilterFunction = IsolatedClass.isolateClass(new DynamicClassLoader(this.getClass().getClassLoader()), JoinFilterFunction.class, StandardJoinFilterFunction.class, new Class[0]);
                this.isolatedJoinFilterFunctionConstructor = isolatedJoinFilterFunction.getConstructor(InternalJoinFilterFunction.class, LongArrayList.class, List.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public JoinFilterFunction create(ConnectorSession session, LongArrayList addresses, List<Page> pages) {
            try {
                InternalJoinFilterFunction internalJoinFilterFunction = this.internalJoinFilterFunctionConstructor.newInstance(session);
                return this.isolatedJoinFilterFunctionConstructor.newInstance(internalJoinFilterFunction, addresses, pages);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class JoinFilterCacheKey {
        private final RowExpression filter;
        private final int leftBlocksSize;

        public JoinFilterCacheKey(RowExpression filter, int leftBlocksSize) {
            this.filter = Objects.requireNonNull(filter, "filter can not be null");
            this.leftBlocksSize = leftBlocksSize;
        }

        public RowExpression getFilter() {
            return this.filter;
        }

        public int getLeftBlocksSize() {
            return this.leftBlocksSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JoinFilterCacheKey that = (JoinFilterCacheKey)o;
            return this.leftBlocksSize == that.leftBlocksSize && Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return Objects.hash(this.leftBlocksSize, this.filter);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter).add("leftBlocksSize", this.leftBlocksSize).toString();
        }
    }

    public static interface JoinFilterFunctionFactory {
        public JoinFilterFunction create(ConnectorSession var1, LongArrayList var2, List<Page> var3);
    }
}

