/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.NullableBooleanState;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.lambda.BinaryFunctionInterface;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ReduceAggregationFunction
extends SqlAggregationFunction {
    public static final ReduceAggregationFunction REDUCE_AGG = new ReduceAggregationFunction();
    private static final String NAME = "reduce_agg";
    private static final MethodHandle LONG_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", NullableLongState.class, Object.class, Long.TYPE, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle DOUBLE_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", NullableDoubleState.class, Object.class, Double.TYPE, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle BOOLEAN_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", NullableBooleanState.class, Object.class, Boolean.TYPE, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle LONG_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", NullableLongState.class, NullableLongState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle DOUBLE_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", NullableDoubleState.class, NullableDoubleState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle BOOLEAN_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", NullableBooleanState.class, NullableBooleanState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle LONG_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableLongState.class, "write", Type.class, NullableLongState.class, BlockBuilder.class);
    private static final MethodHandle DOUBLE_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableDoubleState.class, "write", Type.class, NullableDoubleState.class, BlockBuilder.class);
    private static final MethodHandle BOOLEAN_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableBooleanState.class, "write", Type.class, NullableBooleanState.class, BlockBuilder.class);

    public ReduceAggregationFunction() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T"), (Object)Signature.typeVariable("S")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"S"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"S"), (Object)TypeSignature.parseTypeSignature((String)"function(S,T,S)"), (Object)TypeSignature.parseTypeSignature((String)"function(S,S,S)")));
    }

    @Override
    public String getDescription() {
        return "Reduce input elements into a single value";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type inputType = boundVariables.getTypeVariable("T");
        Type stateType = boundVariables.getTypeVariable("S");
        return this.generateAggregation(inputType, stateType);
    }

    private InternalAggregationFunction generateAggregation(Type inputType, Type stateType) {
        AggregationMetadata.AccumulatorStateDescriptor stateDescriptor;
        MethodHandle outputMethodHandle;
        MethodHandle combineMethodHandle;
        MethodHandle inputMethodHandle;
        DynamicClassLoader classLoader = new DynamicClassLoader(ReduceAggregationFunction.class.getClassLoader());
        if (stateType.getJavaType() == Long.TYPE) {
            inputMethodHandle = LONG_STATE_INPUT_FUNCTION;
            combineMethodHandle = LONG_STATE_COMBINE_FUNCTION;
            outputMethodHandle = LONG_STATE_OUTPUT_FUNCTION.bindTo(stateType);
            stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(NullableLongState.class, StateCompiler.generateStateSerializer(NullableLongState.class, classLoader), StateCompiler.generateStateFactory(NullableLongState.class, classLoader));
        } else if (stateType.getJavaType() == Double.TYPE) {
            inputMethodHandle = DOUBLE_STATE_INPUT_FUNCTION;
            combineMethodHandle = DOUBLE_STATE_COMBINE_FUNCTION;
            outputMethodHandle = DOUBLE_STATE_OUTPUT_FUNCTION.bindTo(stateType);
            stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(NullableDoubleState.class, StateCompiler.generateStateSerializer(NullableDoubleState.class, classLoader), StateCompiler.generateStateFactory(NullableDoubleState.class, classLoader));
        } else if (stateType.getJavaType() == Boolean.TYPE) {
            inputMethodHandle = BOOLEAN_STATE_INPUT_FUNCTION;
            combineMethodHandle = BOOLEAN_STATE_COMBINE_FUNCTION;
            outputMethodHandle = BOOLEAN_STATE_OUTPUT_FUNCTION.bindTo(stateType);
            stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(NullableBooleanState.class, StateCompiler.generateStateSerializer(NullableBooleanState.class, classLoader), StateCompiler.generateStateFactory(NullableBooleanState.class, classLoader));
        } else {
            throw new UnsupportedOperationException();
        }
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.getSignature().getName(), inputType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)inputType.getTypeSignature())), ReduceAggregationFunction.createInputParameterMetadata(inputType, stateType), inputMethodHandle.asType(inputMethodHandle.type().changeParameterType(1, inputType.getJavaType())), combineMethodHandle, outputMethodHandle, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)stateDescriptor), inputType, (List<Class>)ImmutableList.of(BinaryFunctionInterface.class, BinaryFunctionInterface.class));
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(this.getSignature().getName(), (List<Type>)ImmutableList.of((Object)inputType), (List<Type>)ImmutableList.of((Object)stateType), stateType, true, false, factory, (List<Class>)ImmutableList.of(BinaryFunctionInterface.class, BinaryFunctionInterface.class));
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type inputType, Type stateType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, inputType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, stateType));
    }

    public static void input(NullableLongState state, Object value, long initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(initialStateValue);
        }
        state.setLong((Long)inputFunction.apply(state.getLong(), value));
    }

    public static void input(NullableDoubleState state, Object value, double initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(initialStateValue);
        }
        state.setDouble((Double)inputFunction.apply(state.getDouble(), value));
    }

    public static void input(NullableBooleanState state, Object value, boolean initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setBoolean(initialStateValue);
        }
        state.setBoolean((Boolean)inputFunction.apply(state.getBoolean(), value));
    }

    public static void combine(NullableLongState state, NullableLongState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(otherState.getLong());
            return;
        }
        state.setLong((Long)combineFunction.apply(state.getLong(), otherState.getLong()));
    }

    public static void combine(NullableDoubleState state, NullableDoubleState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(otherState.getDouble());
            return;
        }
        state.setDouble((Double)combineFunction.apply(state.getDouble(), otherState.getDouble()));
    }

    public static void combine(NullableBooleanState state, NullableBooleanState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setBoolean(otherState.getBoolean());
            return;
        }
        state.setBoolean((Boolean)combineFunction.apply(state.getBoolean(), otherState.getBoolean()));
    }
}

