/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.HyperLogLogState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.util.Failures;
import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;
import java.lang.invoke.MethodHandle;

@AggregationFunction(value="approx_distinct")
public final class ApproximateCountDistinctAggregation {
    private static final double LOWEST_MAX_STANDARD_ERROR = 0.0040625;
    private static final double HIGHEST_MAX_STANDARD_ERROR = 0.26;

    private ApproximateCountDistinctAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState HyperLogLogState state, @BlockPosition @SqlType(value="unknown") Block block, @BlockIndex int index, @SqlType(value="double") double maxStandardError) {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, returnType="bigint", argumentTypes={"T"}) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") long value, @SqlType(value="double") double maxStandardError) {
        long hash;
        HyperLogLog hll = ApproximateCountDistinctAggregation.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, returnType="bigint", argumentTypes={"T"}) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") double value, @SqlType(value="double") double maxStandardError) {
        long hash;
        HyperLogLog hll = ApproximateCountDistinctAggregation.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, returnType="bigint", argumentTypes={"T"}) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") Slice value, @SqlType(value="double") double maxStandardError) {
        long hash;
        HyperLogLog hll = ApproximateCountDistinctAggregation.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    private static HyperLogLog getOrCreateHyperLogLog(HyperLogLogState state, double maxStandardError) {
        HyperLogLog hll = state.getHyperLogLog();
        if (hll == null) {
            hll = HyperLogLog.newInstance((int)ApproximateCountDistinctAggregation.standardErrorToBuckets(maxStandardError));
            state.setHyperLogLog(hll);
            state.addMemoryUsage(hll.estimatedInMemorySize());
        }
        return hll;
    }

    @VisibleForTesting
    static int standardErrorToBuckets(double maxStandardError) {
        Failures.checkCondition(maxStandardError >= 0.0040625 && maxStandardError <= 0.26, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Max standard error must be in [%s, %s]: %s", 0.0040625, 0.26, maxStandardError);
        return ApproximateCountDistinctAggregation.log2Ceiling((int)Math.ceil(1.0816 / (maxStandardError * maxStandardError)));
    }

    private static int log2Ceiling(int value) {
        return Integer.highestOneBit(value - 1) << 1;
    }

    @CombineFunction
    public static void combineState(@AggregationState HyperLogLogState state, @AggregationState HyperLogLogState otherState) {
        HyperLogLog input = otherState.getHyperLogLog();
        HyperLogLog previous = state.getHyperLogLog();
        if (previous == null) {
            state.setHyperLogLog(input);
            state.addMemoryUsage(input.estimatedInMemorySize());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySize());
            previous.mergeWith(input);
            state.addMemoryUsage(previous.estimatedInMemorySize());
        }
    }

    @OutputFunction(value="bigint")
    public static void evaluateFinal(@AggregationState HyperLogLogState state, BlockBuilder out) {
        HyperLogLog hyperLogLog = state.getHyperLogLog();
        if (hyperLogLog == null) {
            BigintType.BIGINT.writeLong(out, 0L);
        } else {
            BigintType.BIGINT.writeLong(out, hyperLogLog.cardinality());
        }
    }
}

