/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.ParametricImplementation;
import com.facebook.presto.operator.aggregation.AggregationHeader;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.NullablePosition;
import com.facebook.presto.operator.annotations.FunctionsParserHelper;
import com.facebook.presto.operator.annotations.ImplementationDependency;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class AggregationImplementation
implements ParametricImplementation {
    private final Signature signature;
    private final Class<?> definitionClass;
    private final Class<?> stateClass;
    private final MethodHandle inputFunction;
    private final MethodHandle outputFunction;
    private final MethodHandle combineFunction;
    private final Optional<MethodHandle> stateSerializerFactory;
    private final List<AggregateNativeContainerType> argumentNativeContainerTypes;
    private final List<ImplementationDependency> inputDependencies;
    private final List<ImplementationDependency> combineDependencies;
    private final List<ImplementationDependency> outputDependencies;
    private final List<ImplementationDependency> stateSerializerFactoryDependencies;
    private final List<AggregationMetadata.ParameterMetadata.ParameterType> inputParameterMetadataTypes;

    public AggregationImplementation(Signature signature, Class<?> definitionClass, Class<?> stateClass, MethodHandle inputFunction, MethodHandle outputFunction, MethodHandle combineFunction, Optional<MethodHandle> stateSerializerFactory, List<AggregateNativeContainerType> argumentNativeContainerTypes, List<ImplementationDependency> inputDependencies, List<ImplementationDependency> combineDependencies, List<ImplementationDependency> outputDependencies, List<ImplementationDependency> stateSerializerFactoryDependencies, List<AggregationMetadata.ParameterMetadata.ParameterType> inputParameterMetadataTypes) {
        this.signature = Objects.requireNonNull(signature, "signature cannot be null");
        this.definitionClass = Objects.requireNonNull(definitionClass, "definition class cannot be null");
        this.stateClass = Objects.requireNonNull(stateClass, "stateClass cannot be null");
        this.inputFunction = Objects.requireNonNull(inputFunction, "inputFunction cannot be null");
        this.outputFunction = Objects.requireNonNull(outputFunction, "outputFunction cannot be null");
        this.combineFunction = Objects.requireNonNull(combineFunction, "combineFunction cannot be null");
        this.stateSerializerFactory = Objects.requireNonNull(stateSerializerFactory, "stateSerializerFactory cannot be null");
        this.argumentNativeContainerTypes = Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes cannot be null");
        this.inputDependencies = Objects.requireNonNull(inputDependencies, "inputDependencies cannot be null");
        this.outputDependencies = Objects.requireNonNull(outputDependencies, "outputDependencies cannot be null");
        this.combineDependencies = Objects.requireNonNull(combineDependencies, "combineDependencies cannot be null");
        this.stateSerializerFactoryDependencies = Objects.requireNonNull(stateSerializerFactoryDependencies, "stateSerializerFactoryDependencies cannot be null");
        this.inputParameterMetadataTypes = Objects.requireNonNull(inputParameterMetadataTypes, "inputParameterMetadataTypes cannot be null");
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean hasSpecializedTypeParameters() {
        return false;
    }

    public Class<?> getDefinitionClass() {
        return this.definitionClass;
    }

    public Class<?> getStateClass() {
        return this.stateClass;
    }

    public MethodHandle getInputFunction() {
        return this.inputFunction;
    }

    public MethodHandle getOutputFunction() {
        return this.outputFunction;
    }

    public MethodHandle getCombineFunction() {
        return this.combineFunction;
    }

    public Optional<MethodHandle> getStateSerializerFactory() {
        return this.stateSerializerFactory;
    }

    public List<ImplementationDependency> getInputDependencies() {
        return this.inputDependencies;
    }

    public List<ImplementationDependency> getOutputDependencies() {
        return this.outputDependencies;
    }

    public List<ImplementationDependency> getCombineDependencies() {
        return this.combineDependencies;
    }

    public List<ImplementationDependency> getStateSerializerFactoryDependencies() {
        return this.stateSerializerFactoryDependencies;
    }

    public List<AggregationMetadata.ParameterMetadata.ParameterType> getInputParameterMetadataTypes() {
        return this.inputParameterMetadataTypes;
    }

    public boolean areTypesAssignable(Signature boundSignature, BoundVariables variables, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkState((this.argumentNativeContainerTypes.size() == boundSignature.getArgumentTypes().size() ? 1 : 0) != 0, (Object)"Number of argument assigned to AggregationImplementation is different than number parsed from annotations.");
        for (int i = 0; i < boundSignature.getArgumentTypes().size(); ++i) {
            Class argumentType = typeManager.getType(boundSignature.getArgumentTypes().get(i)).getJavaType();
            Class<?> methodDeclaredType = this.argumentNativeContainerTypes.get(i).getJavaType();
            boolean isCurrentBlockPosition = this.argumentNativeContainerTypes.get(i).isBlockPosition();
            if (isCurrentBlockPosition && Block.class.isAssignableFrom(methodDeclaredType) || !isCurrentBlockPosition && argumentType.isAssignableFrom(methodDeclaredType)) continue;
            return false;
        }
        return true;
    }

    public static final class Parser {
        private final Class<?> aggregationDefinition;
        private final Class<?> stateClass;
        private final MethodHandle inputHandle;
        private final MethodHandle outputHandle;
        private final MethodHandle combineHandle;
        private final Optional<MethodHandle> stateSerializerFactoryHandle;
        private final List<AggregateNativeContainerType> argumentNativeContainerTypes;
        private final List<ImplementationDependency> inputDependencies;
        private final List<ImplementationDependency> combineDependencies;
        private final List<ImplementationDependency> outputDependencies;
        private final List<ImplementationDependency> stateSerializerFactoryDependencies;
        private final List<AggregationMetadata.ParameterMetadata.ParameterType> parameterMetadataTypes;
        private final List<LongVariableConstraint> longVariableConstraints;
        private final List<TypeVariableConstraint> typeVariableConstraints;
        private final List<TypeSignature> inputTypes;
        private final TypeSignature returnType;
        private final AggregationHeader header;
        private final Set<String> literalParameters;
        private final List<TypeParameter> typeParameters;

        private Parser(Class<?> aggregationDefinition, AggregationHeader header, Class<?> stateClass, Method inputFunction, Method outputFunction, Method combineFunction, Optional<Method> stateSerializerFactoryFunction) {
            this.aggregationDefinition = aggregationDefinition;
            this.header = header;
            this.stateClass = stateClass;
            this.literalParameters = FunctionsParserHelper.parseLiteralParameters(inputFunction);
            this.typeParameters = Arrays.asList(inputFunction.getAnnotationsByType(TypeParameter.class));
            this.inputDependencies = this.parseImplementationDependencies(inputFunction);
            this.outputDependencies = this.parseImplementationDependencies(outputFunction);
            this.combineDependencies = this.parseImplementationDependencies(combineFunction);
            this.stateSerializerFactoryDependencies = stateSerializerFactoryFunction.map(this::parseImplementationDependencies).orElse((List)ImmutableList.of());
            this.parameterMetadataTypes = Parser.parseParameterMetadataTypes(inputFunction);
            this.longVariableConstraints = FunctionsParserHelper.parseLongVariableConstraints(inputFunction);
            List allDependencies = (List)Stream.of(this.inputDependencies.stream(), this.outputDependencies.stream(), this.combineDependencies.stream()).reduce(Stream::concat).orElseGet(Stream::empty).collect(ImmutableList.toImmutableList());
            this.typeVariableConstraints = FunctionsParserHelper.createTypeVariableConstraints(this.typeParameters, allDependencies);
            this.argumentNativeContainerTypes = Parser.parseSignatureArgumentsTypes(inputFunction);
            this.inputTypes = this.getInputTypesSignatures(inputFunction);
            this.returnType = TypeSignature.parseTypeSignature((String)outputFunction.getAnnotation(OutputFunction.class).value(), this.literalParameters);
            this.stateSerializerFactoryHandle = stateSerializerFactoryFunction.isPresent() ? Optional.of(Reflection.methodHandle(stateSerializerFactoryFunction.get())) : Optional.empty();
            this.inputHandle = Reflection.methodHandle(inputFunction);
            this.combineHandle = Reflection.methodHandle(combineFunction);
            this.outputHandle = Reflection.methodHandle(outputFunction);
        }

        private AggregationImplementation get() {
            Signature signature = new Signature(this.header.getName(), FunctionKind.AGGREGATE, this.typeVariableConstraints, this.longVariableConstraints, this.returnType, this.inputTypes, false);
            return new AggregationImplementation(signature, this.aggregationDefinition, this.stateClass, this.inputHandle, this.outputHandle, this.combineHandle, this.stateSerializerFactoryHandle, this.argumentNativeContainerTypes, this.inputDependencies, this.combineDependencies, this.outputDependencies, this.stateSerializerFactoryDependencies, this.parameterMetadataTypes);
        }

        public static AggregationImplementation parseImplementation(Class<?> aggregationDefinition, AggregationHeader header, Class<?> stateClass, Method inputFunction, Method outputFunction, Method combineFunction, Optional<Method> stateSerializerFactoryFunction) {
            return new Parser(aggregationDefinition, header, stateClass, inputFunction, outputFunction, combineFunction, stateSerializerFactoryFunction).get();
        }

        private static List<AggregationMetadata.ParameterMetadata.ParameterType> parseParameterMetadataTypes(Method method) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Annotation[][] annotations = method.getParameterAnnotations();
            String methodName = method.getDeclaringClass() + "." + method.getName();
            Preconditions.checkArgument((method.getParameterCount() > 0 ? 1 : 0) != 0, (Object)"At least @AggregationState argument is required for each of aggregation functions.");
            int i = 0;
            if (annotations[0].length == 0) {
                builder.add((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE);
                ++i;
            }
            while (i < annotations.length) {
                Annotation baseTypeAnnotation = Parser.baseTypeAnnotation(annotations[i], methodName);
                if (!ImplementationDependency.isImplementationDependencyAnnotation(baseTypeAnnotation)) {
                    if (baseTypeAnnotation instanceof AggregationState) {
                        builder.add((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE);
                    } else if (baseTypeAnnotation instanceof SqlType) {
                        boolean isParameterBlock = Parser.isParameterBlock(annotations[i]);
                        boolean isParameterNullable = Parser.isParameterNullable(annotations[i]);
                        builder.add((Object)AggregationMetadata.ParameterMetadata.ParameterType.inputChannelParameterType(isParameterNullable, isParameterBlock, methodName));
                    } else if (baseTypeAnnotation instanceof BlockIndex) {
                        builder.add((Object)AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX);
                    } else {
                        throw new IllegalArgumentException("Unsupported annotation: " + annotations[i]);
                    }
                }
                ++i;
            }
            return builder.build();
        }

        private static Annotation baseTypeAnnotation(Annotation[] annotations, String methodName) {
            List baseTypes = (List)Arrays.asList(annotations).stream().filter(annotation -> Parser.isAggregationMetaAnnotation(annotation) || annotation instanceof SqlType).collect(ImmutableList.toImmutableList());
            Preconditions.checkArgument((baseTypes.size() == 1 ? 1 : 0) != 0, (String)"Parameter of %s must have exactly one of @SqlType, @BlockIndex", (Object)methodName);
            boolean nullable = Parser.isParameterNullable(annotations);
            boolean isBlock = Parser.isParameterBlock(annotations);
            Annotation annotation2 = (Annotation)baseTypes.get(0);
            Preconditions.checkArgument((!isBlock && !nullable || annotation2 instanceof SqlType ? 1 : 0) != 0, (String)"%s contains a parameter with @BlockPosition and/or @NullablePosition that is not @SqlType", (Object)methodName);
            return annotation2;
        }

        public static List<AggregateNativeContainerType> parseSignatureArgumentsTypes(Method inputFunction) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int stateId = Parser.findAggregationStateParamId(inputFunction);
            for (int i = 0; i < inputFunction.getParameterCount(); ++i) {
                Class<?> parameterType = inputFunction.getParameterTypes()[i];
                Annotation[] annotations = inputFunction.getParameterAnnotations()[i];
                if (parameterType == ConnectorSession.class || FunctionsParserHelper.containsAnnotation(annotations, Parser::isAggregationMetaAnnotation)) continue;
                builder.add((Object)new AggregateNativeContainerType(inputFunction.getParameterTypes()[i], Parser.isParameterBlock(annotations)));
            }
            return builder.build();
        }

        public List<ImplementationDependency> parseImplementationDependencies(Method inputFunction) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Parameter parameter : inputFunction.getParameters()) {
                Class<?> parameterType = parameter.getType();
                if (parameterType == ConnectorSession.class) continue;
                ImplementationDependency.getImplementationDependencyAnnotation(parameter).ifPresent(annotation -> {
                    ImplementationDependency.validateImplementationDependencyAnnotation(inputFunction, annotation, (Set)this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableSet.toImmutableSet()), this.literalParameters);
                    builder.add((Object)ImplementationDependency.Factory.createDependency(annotation, this.literalParameters));
                });
            }
            return builder.build();
        }

        public static boolean isParameterNullable(Annotation[] annotations) {
            return FunctionsParserHelper.containsAnnotation(annotations, annotation -> annotation instanceof NullablePosition);
        }

        public static boolean isParameterBlock(Annotation[] annotations) {
            return FunctionsParserHelper.containsAnnotation(annotations, annotation -> annotation instanceof BlockPosition);
        }

        public List<TypeSignature> getInputTypesSignatures(Method inputFunction) {
            Annotation[][] parameterAnnotations;
            ImmutableList.Builder builder = ImmutableList.builder();
            Annotation[][] annotationArray = parameterAnnotations = inputFunction.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    if (!(annotation instanceof SqlType)) continue;
                    String typeName = ((SqlType)annotation).value();
                    builder.add((Object)TypeSignature.parseTypeSignature((String)typeName, this.literalParameters));
                }
            }
            return builder.build();
        }

        public static Class<?> findAggregationStateParamType(Method inputFunction) {
            return inputFunction.getParameterTypes()[Parser.findAggregationStateParamId(inputFunction)];
        }

        public static int findAggregationStateParamId(Method method) {
            return Parser.findAggregationStateParamId(method, 0);
        }

        public static int findAggregationStateParamId(Method method, int id) {
            int currentParamId = 0;
            int found = 0;
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    if (!(annotation instanceof AggregationState) || found++ != id) continue;
                    return currentParamId;
                }
                ++currentParamId;
            }
            return id;
        }

        private static boolean isAggregationMetaAnnotation(Annotation annotation) {
            return annotation instanceof BlockIndex || annotation instanceof AggregationState || ImplementationDependency.isImplementationDependencyAnnotation(annotation);
        }
    }

    public static class AggregateNativeContainerType {
        private final Class<?> javaType;
        private final boolean isBlockPosition;

        public AggregateNativeContainerType(Class<?> javaType, boolean isBlockPosition) {
            this.javaType = javaType;
            this.isBlockPosition = isBlockPosition;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }

        public boolean isBlockPosition() {
            return this.isBlockPosition;
        }
    }
}

