/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StageExecutionStrategy {
    private final Set<PlanNodeId> groupedExecutionScanNodes;

    private StageExecutionStrategy(Set<PlanNodeId> groupedExecutionScanNodes) {
        this.groupedExecutionScanNodes = groupedExecutionScanNodes;
    }

    public static StageExecutionStrategy ungroupedExecution() {
        return new StageExecutionStrategy((Set<PlanNodeId>)ImmutableSet.of());
    }

    public static StageExecutionStrategy groupedExecution(List<PlanNodeId> capableScanNodes) {
        Objects.requireNonNull(capableScanNodes, "capableScanNodes is null");
        Preconditions.checkArgument((!capableScanNodes.isEmpty() ? 1 : 0) != 0);
        return new StageExecutionStrategy((Set<PlanNodeId>)ImmutableSet.copyOf(capableScanNodes));
    }

    public boolean isAnyScanGroupedExecution() {
        return !this.groupedExecutionScanNodes.isEmpty();
    }

    public boolean isGroupedExecution(PlanNodeId scanNodeId) {
        return this.groupedExecutionScanNodes.contains(scanNodeId);
    }

    @JsonCreator
    public static StageExecutionStrategy jsonCreator(@JsonProperty(value="groupedExecutionScanNodes") Set<PlanNodeId> groupedExecutionCapableScanNodes) {
        return new StageExecutionStrategy((Set<PlanNodeId>)ImmutableSet.copyOf((Collection)Objects.requireNonNull(groupedExecutionCapableScanNodes, "groupedExecutionScanNodes is null")));
    }

    @JsonProperty(value="groupedExecutionScanNodes")
    public Set<PlanNodeId> getJsonSerializableGroupedExecutionScanNodes() {
        return this.groupedExecutionScanNodes;
    }
}

