/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.memory.QueryContextVisitor;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperationTimer;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

public class OperatorContext {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private final DriverContext driverContext;
    private final Executor executor;
    private final CounterStat rawInputDataSize = new CounterStat();
    private final OperationTimer.OperationTiming addInputTiming = new OperationTimer.OperationTiming();
    private final CounterStat inputDataSize = new CounterStat();
    private final CounterStat inputPositions = new CounterStat();
    private final OperationTimer.OperationTiming getOutputTiming = new OperationTimer.OperationTiming();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final AtomicLong physicalWrittenDataSize = new AtomicLong();
    private final AtomicReference<SettableFuture<?>> memoryFuture;
    private final AtomicReference<SettableFuture<?>> revocableMemoryFuture;
    private final AtomicReference<BlockedMonitor> blockedMonitor = new AtomicReference();
    private final AtomicLong blockedWallNanos = new AtomicLong();
    private final OperationTimer.OperationTiming finishTiming = new OperationTimer.OperationTiming();
    private final SpillContext spillContext;
    private final AtomicReference<Supplier<OperatorInfo>> infoSupplier = new AtomicReference();
    private final AtomicLong peakUserMemoryReservation = new AtomicLong();
    private final AtomicLong peakSystemMemoryReservation = new AtomicLong();
    private final AtomicLong peakTotalMemoryReservation = new AtomicLong();
    @GuardedBy(value="this")
    private boolean memoryRevokingRequested;
    @Nullable
    @GuardedBy(value="this")
    private Runnable memoryRevocationRequestListener;
    private final MemoryTrackingContext operatorMemoryContext;

    public OperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType, DriverContext driverContext, Executor executor, MemoryTrackingContext operatorMemoryContext) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.driverContext = Objects.requireNonNull(driverContext, "driverContext is null");
        this.spillContext = new OperatorSpillContext(this.driverContext);
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.memoryFuture = new AtomicReference<SettableFuture>(SettableFuture.create());
        this.memoryFuture.get().set(null);
        this.revocableMemoryFuture = new AtomicReference<SettableFuture>(SettableFuture.create());
        this.revocableMemoryFuture.get().set(null);
        this.operatorMemoryContext = Objects.requireNonNull(operatorMemoryContext, "operatorMemoryContext is null");
        operatorMemoryContext.initializeLocalMemoryContexts(operatorType);
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public String getOperatorType() {
        return this.operatorType;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public Session getSession() {
        return this.driverContext.getSession();
    }

    public boolean isDone() {
        return this.driverContext.isDone();
    }

    void recordAddInput(OperationTimer operationTimer, Page page) {
        operationTimer.recordOperationComplete(this.addInputTiming);
        if (page != null) {
            this.inputDataSize.update(page.getSizeInBytes());
            this.inputPositions.update((long)page.getPositionCount());
        }
    }

    public void recordRawInput(long sizeInBytes) {
        this.rawInputDataSize.update(sizeInBytes);
    }

    public void recordRawInputWithTiming(long sizeInBytes, long readNanos) {
        this.rawInputDataSize.update(sizeInBytes);
        this.addInputTiming.record(readNanos, 0L);
    }

    public void recordProcessedInput(long sizeInBytes, long positions) {
        this.inputDataSize.update(sizeInBytes);
        this.inputPositions.update(positions);
    }

    void recordGetOutput(OperationTimer operationTimer, Page page) {
        operationTimer.recordOperationComplete(this.getOutputTiming);
        if (page != null) {
            this.outputDataSize.update(page.getSizeInBytes());
            this.outputPositions.update((long)page.getPositionCount());
        }
    }

    public void recordOutput(long sizeInBytes, long positions) {
        this.outputDataSize.update(sizeInBytes);
        this.outputPositions.update(positions);
    }

    public void recordPhysicalWrittenData(long sizeInBytes) {
        this.physicalWrittenDataSize.getAndAdd(sizeInBytes);
    }

    public void recordBlocked(ListenableFuture<?> blocked) {
        Objects.requireNonNull(blocked, "blocked is null");
        BlockedMonitor monitor = new BlockedMonitor();
        BlockedMonitor oldMonitor = this.blockedMonitor.getAndSet(monitor);
        if (oldMonitor != null) {
            oldMonitor.run();
        }
        blocked.addListener((Runnable)monitor, this.executor);
    }

    void recordFinish(OperationTimer operationTimer) {
        operationTimer.recordOperationComplete(this.finishTiming);
    }

    public ListenableFuture<?> isWaitingForMemory() {
        return (ListenableFuture)this.memoryFuture.get();
    }

    public ListenableFuture<?> isWaitingForRevocableMemory() {
        return (ListenableFuture)this.revocableMemoryFuture.get();
    }

    public LocalMemoryContext newLocalSystemMemoryContext(String allocationTag) {
        return new InternalLocalMemoryContext(this.operatorMemoryContext.newSystemMemoryContext(allocationTag), this.memoryFuture, this::updatePeakMemoryReservations, true);
    }

    public LocalMemoryContext localUserMemoryContext() {
        return new InternalLocalMemoryContext(this.operatorMemoryContext.localUserMemoryContext(), this.memoryFuture, this::updatePeakMemoryReservations, false);
    }

    public LocalMemoryContext localSystemMemoryContext() {
        return new InternalLocalMemoryContext(this.operatorMemoryContext.localSystemMemoryContext(), this.memoryFuture, this::updatePeakMemoryReservations, false);
    }

    public LocalMemoryContext localRevocableMemoryContext() {
        return new InternalLocalMemoryContext(this.operatorMemoryContext.localRevocableMemoryContext(), this.revocableMemoryFuture, () -> {}, false);
    }

    public AggregatedMemoryContext aggregateUserMemoryContext() {
        return new InternalAggregatedMemoryContext(this.operatorMemoryContext.aggregateUserMemoryContext(), this.memoryFuture, this::updatePeakMemoryReservations, false);
    }

    public AggregatedMemoryContext newAggregateSystemMemoryContext() {
        return new InternalAggregatedMemoryContext(this.operatorMemoryContext.newAggregateSystemMemoryContext(), this.memoryFuture, this::updatePeakMemoryReservations, true);
    }

    private void updatePeakMemoryReservations() {
        long userMemory = this.operatorMemoryContext.getUserMemory();
        long systemMemory = this.operatorMemoryContext.getSystemMemory();
        long totalMemory = userMemory + systemMemory;
        this.peakUserMemoryReservation.accumulateAndGet(userMemory, Math::max);
        this.peakSystemMemoryReservation.accumulateAndGet(systemMemory, Math::max);
        this.peakTotalMemoryReservation.accumulateAndGet(totalMemory, Math::max);
    }

    public long getReservedRevocableBytes() {
        return this.operatorMemoryContext.getRevocableMemory();
    }

    private static void updateMemoryFuture(ListenableFuture<?> memoryPoolFuture, AtomicReference<SettableFuture<?>> targetFutureReference) {
        if (!memoryPoolFuture.isDone()) {
            SettableFuture<?> currentMemoryFuture = targetFutureReference.get();
            while (currentMemoryFuture.isDone()) {
                SettableFuture<?> settableFuture = SettableFuture.create();
                if (targetFutureReference.compareAndSet(currentMemoryFuture, settableFuture)) {
                    currentMemoryFuture = settableFuture;
                    continue;
                }
                currentMemoryFuture = targetFutureReference.get();
            }
            SettableFuture<?> finalMemoryFuture = currentMemoryFuture;
            memoryPoolFuture.addListener(() -> finalMemoryFuture.set(null), MoreExecutors.directExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        OperatorContext operatorContext = this;
        synchronized (operatorContext) {
            this.memoryRevocationRequestListener = null;
        }
        this.operatorMemoryContext.close();
        if (this.operatorMemoryContext.getSystemMemory() != 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Operator %s has non-zero system memory (%d bytes) after destroy()", this, this.operatorMemoryContext.getSystemMemory()));
        }
        if (this.operatorMemoryContext.getUserMemory() != 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Operator %s has non-zero user memory (%d bytes) after destroy()", this, this.operatorMemoryContext.getUserMemory()));
        }
        if (this.operatorMemoryContext.getRevocableMemory() != 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Operator %s has non-zero revocable memory (%d bytes) after destroy()", this, this.operatorMemoryContext.getRevocableMemory()));
        }
    }

    public SpillContext getSpillContext() {
        return this.spillContext;
    }

    public void moreMemoryAvailable() {
        this.memoryFuture.get().set(null);
    }

    public synchronized boolean isMemoryRevokingRequested() {
        return this.memoryRevokingRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long requestMemoryRevoking() {
        long revokedMemory = 0L;
        Runnable listener = null;
        OperatorContext operatorContext = this;
        synchronized (operatorContext) {
            if (!this.isMemoryRevokingRequested() && this.operatorMemoryContext.getRevocableMemory() > 0L) {
                this.memoryRevokingRequested = true;
                revokedMemory = this.operatorMemoryContext.getRevocableMemory();
                listener = this.memoryRevocationRequestListener;
            }
        }
        if (listener != null) {
            OperatorContext.runListener(listener);
        }
        return revokedMemory;
    }

    public synchronized void resetMemoryRevokingRequested() {
        this.memoryRevokingRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemoryRevocationRequestListener(Runnable listener) {
        boolean shouldNotify;
        Objects.requireNonNull(listener, "listener is null");
        OperatorContext operatorContext = this;
        synchronized (operatorContext) {
            Preconditions.checkState((this.memoryRevocationRequestListener == null ? 1 : 0) != 0, (Object)"listener already set");
            this.memoryRevocationRequestListener = listener;
            shouldNotify = this.memoryRevokingRequested;
        }
        if (shouldNotify) {
            OperatorContext.runListener(listener);
        }
    }

    private static void runListener(Runnable listener) {
        Objects.requireNonNull(listener, "listener is null");
        try {
            listener.run();
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Exception while running the listener", (Throwable)e);
        }
    }

    public void setInfoSupplier(Supplier<OperatorInfo> infoSupplier) {
        Objects.requireNonNull(infoSupplier, "infoProvider is null");
        this.infoSupplier.set(infoSupplier);
    }

    public CounterStat getInputDataSize() {
        return this.inputDataSize;
    }

    public CounterStat getInputPositions() {
        return this.inputPositions;
    }

    public CounterStat getOutputDataSize() {
        return this.outputDataSize;
    }

    public CounterStat getOutputPositions() {
        return this.outputPositions;
    }

    public long getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize.get();
    }

    public String toString() {
        return String.format("%s-%s", this.operatorType, this.planNodeId);
    }

    public OperatorStats getOperatorStats() {
        Supplier<OperatorInfo> infoSupplier = this.infoSupplier.get();
        OperatorInfo info = Optional.ofNullable(infoSupplier).map(Supplier::get).orElse(null);
        long inputPositionsCount = this.inputPositions.getTotalCount();
        return new OperatorStats(this.driverContext.getTaskId().getStageId().getId(), this.driverContext.getPipelineContext().getPipelineId(), this.operatorId, this.planNodeId, this.operatorType, 1L, this.addInputTiming.getCalls(), new Duration((double)this.addInputTiming.getWallNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.addInputTiming.getCpuNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.rawInputDataSize.getTotalCount()), DataSize.succinctBytes((long)this.inputDataSize.getTotalCount()), inputPositionsCount, (double)inputPositionsCount * (double)inputPositionsCount, this.getOutputTiming.getCalls(), new Duration((double)this.getOutputTiming.getWallNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.getOutputTiming.getCpuNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.outputDataSize.getTotalCount()), this.outputPositions.getTotalCount(), DataSize.succinctBytes((long)this.physicalWrittenDataSize.get()), new Duration((double)this.blockedWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), this.finishTiming.getCalls(), new Duration((double)this.finishTiming.getWallNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.finishTiming.getCpuNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.operatorMemoryContext.getUserMemory()), DataSize.succinctBytes((long)this.getReservedRevocableBytes()), DataSize.succinctBytes((long)this.operatorMemoryContext.getSystemMemory()), DataSize.succinctBytes((long)this.peakUserMemoryReservation.get()), DataSize.succinctBytes((long)this.peakSystemMemoryReservation.get()), DataSize.succinctBytes((long)this.peakTotalMemoryReservation.get()), this.memoryFuture.get().isDone() ? Optional.empty() : Optional.of(BlockedReason.WAITING_FOR_MEMORY), info);
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitOperatorContext(this, context);
    }

    private static long nanosBetween(long start, long end) {
        return Math.max(0L, end - start);
    }

    @VisibleForTesting
    public MemoryTrackingContext getOperatorMemoryContext() {
        return this.operatorMemoryContext;
    }

    private static class InternalAggregatedMemoryContext
    implements AggregatedMemoryContext {
        private final AggregatedMemoryContext delegate;
        private final AtomicReference<SettableFuture<?>> memoryFuture;
        private final Runnable allocationListener;
        private final boolean closeable;

        InternalAggregatedMemoryContext(AggregatedMemoryContext delegate, AtomicReference<SettableFuture<?>> memoryFuture, Runnable allocationListener, boolean closeable) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.memoryFuture = Objects.requireNonNull(memoryFuture, "memoryFuture is null");
            this.allocationListener = Objects.requireNonNull(allocationListener, "allocationListener is null");
            this.closeable = closeable;
        }

        public AggregatedMemoryContext newAggregatedMemoryContext() {
            return this.delegate.newAggregatedMemoryContext();
        }

        public LocalMemoryContext newLocalMemoryContext(String allocationTag) {
            return new InternalLocalMemoryContext(this.delegate.newLocalMemoryContext(allocationTag), this.memoryFuture, this.allocationListener, true);
        }

        public long getBytes() {
            return this.delegate.getBytes();
        }

        public void close() {
            if (!this.closeable) {
                throw new UnsupportedOperationException("Called close on unclosable aggregated memory context");
            }
            this.delegate.close();
        }
    }

    private static class InternalLocalMemoryContext
    implements LocalMemoryContext {
        private final LocalMemoryContext delegate;
        private final AtomicReference<SettableFuture<?>> memoryFuture;
        private final Runnable allocationListener;
        private final boolean closeable;

        InternalLocalMemoryContext(LocalMemoryContext delegate, AtomicReference<SettableFuture<?>> memoryFuture, Runnable allocationListener, boolean closeable) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.memoryFuture = Objects.requireNonNull(memoryFuture, "memoryFuture is null");
            this.allocationListener = Objects.requireNonNull(allocationListener, "allocationListener is null");
            this.closeable = closeable;
        }

        public long getBytes() {
            return this.delegate.getBytes();
        }

        public ListenableFuture<?> setBytes(long bytes) {
            ListenableFuture blocked = this.delegate.setBytes(bytes);
            OperatorContext.updateMemoryFuture(blocked, this.memoryFuture);
            this.allocationListener.run();
            return blocked;
        }

        public boolean trySetBytes(long bytes) {
            return this.delegate.trySetBytes(bytes);
        }

        public void close() {
            if (!this.closeable) {
                throw new UnsupportedOperationException("Called close on unclosable local memory context");
            }
            this.delegate.close();
        }
    }

    @ThreadSafe
    private static class OperatorSpillContext
    implements SpillContext {
        private final DriverContext driverContext;
        private final AtomicLong reservedBytes = new AtomicLong();

        public OperatorSpillContext(DriverContext driverContext) {
            this.driverContext = driverContext;
        }

        @Override
        public void updateBytes(long bytes) {
            if (bytes >= 0L) {
                this.reservedBytes.addAndGet(bytes);
                this.driverContext.reserveSpill(bytes);
            } else {
                this.reservedBytes.accumulateAndGet(-bytes, this::decrementSpilledReservation);
                this.driverContext.freeSpill(-bytes);
            }
        }

        private long decrementSpilledReservation(long reservedBytes, long bytesBeingFreed) {
            Preconditions.checkArgument((bytesBeingFreed >= 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((bytesBeingFreed <= reservedBytes ? 1 : 0) != 0, (String)"tried to free %s spilled bytes from %s bytes reserved", (long)bytesBeingFreed, (long)reservedBytes);
            return reservedBytes - bytesBeingFreed;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException(String.format("%s should not be closed directly", this.getClass()));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("usedBytes", this.reservedBytes.get()).toString();
        }
    }

    private class BlockedMonitor
    implements Runnable {
        private final long start = System.nanoTime();
        private boolean finished;

        private BlockedMonitor() {
        }

        @Override
        public synchronized void run() {
            if (this.finished) {
                return;
            }
            this.finished = true;
            OperatorContext.this.blockedMonitor.compareAndSet(this, null);
            OperatorContext.this.blockedWallNanos.getAndAdd(this.getBlockedTime());
        }

        public long getBlockedTime() {
            return OperatorContext.nanosBetween(this.start, System.nanoTime());
        }
    }
}

