/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DistinctLimitOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private Page inputPage;
    private long remainingLimit;
    private boolean finishing;
    private final List<Integer> outputChannels;
    private final GroupByHash groupByHash;
    private long nextDistinctId;
    private GroupByIdBlock groupByIds;
    private Work<GroupByIdBlock> unfinishedWork;

    public DistinctLimitOperator(OperatorContext operatorContext, List<Integer> distinctChannels, List<Type> distinctTypes, long limit, Optional<Integer> hashChannel, JoinCompiler joinCompiler) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        Objects.requireNonNull(distinctChannels, "distinctChannels is null");
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
        Objects.requireNonNull(hashChannel, "hashChannel is null");
        this.outputChannels = ImmutableList.builder().addAll(distinctChannels).addAll((Iterable)hashChannel.map(ImmutableList::of).orElse(ImmutableList.of())).build();
        this.groupByHash = GroupByHash.createGroupByHash(distinctTypes, Ints.toArray(distinctChannels), hashChannel, Math.min((int)limit, 10000), SystemSessionProperties.isDictionaryAggregationEnabled(operatorContext.getSession()), joinCompiler, this::updateMemoryReservation);
        this.remainingLimit = limit;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return !this.hasUnfinishedInput() && (this.finishing || this.remainingLimit == 0L);
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.remainingLimit > 0L && !this.hasUnfinishedInput();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
        this.inputPage = page;
        this.unfinishedWork = this.groupByHash.getGroupIds(page);
        this.processUnfinishedWork();
        this.updateMemoryReservation();
    }

    @Override
    public Page getOutput() {
        if (this.unfinishedWork != null && !this.processUnfinishedWork()) {
            return null;
        }
        if (this.groupByIds == null) {
            return null;
        }
        Verify.verify((this.inputPage != null ? 1 : 0) != 0);
        int distinctCount = 0;
        int[] distinctPositions = new int[this.inputPage.getPositionCount()];
        for (int position = 0; position < this.groupByIds.getPositionCount(); ++position) {
            if (this.groupByIds.getGroupId(position) != this.nextDistinctId) continue;
            distinctPositions[distinctCount] = position;
            ++distinctCount;
            --this.remainingLimit;
            ++this.nextDistinctId;
            if (this.remainingLimit == 0L) break;
        }
        Page result = this.maskToDistinctOutputPositions(distinctCount, distinctPositions);
        this.groupByIds = null;
        this.inputPage = null;
        this.updateMemoryReservation();
        return result;
    }

    private Page maskToDistinctOutputPositions(int distinctCount, int[] distinctPositions) {
        Page result = null;
        if (distinctCount > 0) {
            Block[] blocks = (Block[])this.outputChannels.stream().map(arg_0 -> ((Page)this.inputPage).getBlock(arg_0)).map(block -> block.getPositions(distinctPositions, 0, distinctCount)).toArray(Block[]::new);
            result = new Page(distinctCount, blocks);
        }
        return result;
    }

    private boolean processUnfinishedWork() {
        Verify.verify((this.unfinishedWork != null ? 1 : 0) != 0);
        if (!this.unfinishedWork.process()) {
            return false;
        }
        this.groupByIds = this.unfinishedWork.getResult();
        this.unfinishedWork = null;
        return true;
    }

    private boolean hasUnfinishedInput() {
        return this.inputPage != null || this.unfinishedWork != null;
    }

    private boolean updateMemoryReservation() {
        this.localUserMemoryContext.setBytes(this.groupByHash.getEstimatedSize());
        return this.operatorContext.isWaitingForMemory().isDone();
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }

    public static class DistinctLimitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Integer> distinctChannels;
        private final List<Type> sourceTypes;
        private final long limit;
        private final Optional<Integer> hashChannel;
        private boolean closed;
        private final JoinCompiler joinCompiler;

        public DistinctLimitOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, List<Integer> distinctChannels, long limit, Optional<Integer> hashChannel, JoinCompiler joinCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
            this.distinctChannels = Objects.requireNonNull(distinctChannels, "distinctChannels is null");
            Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
            this.limit = limit;
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, DistinctLimitOperator.class.getSimpleName());
            List distinctTypes = (List)this.distinctChannels.stream().map(this.sourceTypes::get).collect(ImmutableList.toImmutableList());
            return new DistinctLimitOperator(operatorContext, this.distinctChannels, distinctTypes, this.limit, this.hashChannel, this.joinCompiler);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new DistinctLimitOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.distinctChannels, this.limit, this.hashChannel, this.joinCompiler);
        }
    }
}

